/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader.serial.conversion;

import com.limegroup.gnutella.downloader.serial.conversion.SerialBTDownloader;
import com.limegroup.gnutella.downloader.serial.conversion.SerialBTMetaInfo;
import com.limegroup.gnutella.downloader.serial.conversion.SerialBandwidthTrackerImpl;
import com.limegroup.gnutella.downloader.serial.conversion.SerialBlockRangeMap;
import com.limegroup.gnutella.downloader.serial.conversion.SerialDiskManagerData;
import com.limegroup.gnutella.downloader.serial.conversion.SerialInNetworkDownloader;
import com.limegroup.gnutella.downloader.serial.conversion.SerialIncompleteFileManager;
import com.limegroup.gnutella.downloader.serial.conversion.SerialMagnetDownloader;
import com.limegroup.gnutella.downloader.serial.conversion.SerialManagedDownloaderImpl;
import com.limegroup.gnutella.downloader.serial.conversion.SerialOldURI;
import com.limegroup.gnutella.downloader.serial.conversion.SerialRemoteFileDesc3x0;
import com.limegroup.gnutella.downloader.serial.conversion.SerialRemoteFileDesc4x14;
import com.limegroup.gnutella.downloader.serial.conversion.SerialRemoteFileDesc4x16;
import com.limegroup.gnutella.downloader.serial.conversion.SerialRequeryDownloader;
import com.limegroup.gnutella.downloader.serial.conversion.SerialResumeDownloader4x11;
import com.limegroup.gnutella.downloader.serial.conversion.SerialResumeDownloader4x16;
import com.limegroup.gnutella.downloader.serial.conversion.SerialRoot;
import com.limegroup.gnutella.downloader.serial.conversion.SerialStoreDownloader;
import com.limegroup.gnutella.downloader.serial.conversion.SerialTorrentFileSystem;
import com.limegroup.gnutella.downloader.serial.conversion.SerialUrlRemoteFileDesc;
import com.limegroup.gnutella.xml.SerialXml;
import java.io.IOException;
import java.io.InputStream;
import org.limewire.collection.IntervalSet;
import org.limewire.util.ConverterObjectInputStream;

class DownloadConverterObjectInputStream
extends ConverterObjectInputStream {
    DownloadConverterObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.deserializeVersion(Version.Four16);
    }

    void deserializeVersion(Version version) {
        this.revertToDefault();
        this.addCommon();
        switch (version) {
            case Four16: {
                this.addLookup("com.limegroup.gnutella.downloader.ResumeDownloader", SerialResumeDownloader4x16.class.getName());
                this.addLookup("com.limegroup.gnutella.RemoteFileDesc", SerialRemoteFileDesc4x16.class.getName());
                break;
            }
            case Four14: {
                this.addLookup("com.limegroup.gnutella.downloader.ResumeDownloader", SerialResumeDownloader4x16.class.getName());
                this.addLookup("com.limegroup.gnutella.RemoteFileDesc", SerialRemoteFileDesc4x14.class.getName());
                break;
            }
            case Four11: {
                this.addLookup("com.limegroup.gnutella.RemoteFileDesc", SerialRemoteFileDesc4x14.class.getName());
                this.addLookup("com.limegroup.gnutella.downloader.ResumeDownloader", SerialResumeDownloader4x11.class.getName());
                break;
            }
            case Three0: {
                this.addLookup("com.limegroup.gnutella.RemoteFileDesc", SerialRemoteFileDesc3x0.class.getName());
                this.addLookup("com.limegroup.gnutella.downloader.ResumeDownloader", SerialResumeDownloader4x11.class.getName());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid version: " + (Object)((Object)version));
            }
        }
    }

    private void addCommon() {
        this.addLookup("com.limegroup.gnutella.downloader.AbstractDownloader", SerialRoot.class.getName());
        this.addLookup("com.limegroup.gnutella.downloader.ManagedDownloader", SerialManagedDownloaderImpl.class.getName());
        this.addLookup("com.limegroup.gnutella.downloader.StoreDownloader", SerialStoreDownloader.class.getName());
        this.addLookup("com.limegroup.gnutella.downloader.RequeryDownloader", SerialRequeryDownloader.class.getName());
        this.addLookup("com.limegroup.gnutella.downloader.MagnetDownloader", SerialMagnetDownloader.class.getName());
        this.addLookup("com.limegroup.gnutella.downloader.InNetworkDownloader", SerialInNetworkDownloader.class.getName());
        this.addLookup("com.limegroup.bittorrent.BTDownloader", SerialBTDownloader.class.getName());
        this.addLookup("com.limegroup.gnutella.downloader.IncompleteFileManager", SerialIncompleteFileManager.class.getName());
        this.addLookup("com.limegroup.gnutella.downloader.URLRemoteFileDesc", SerialUrlRemoteFileDesc.class.getName());
        this.addLookup("com.limegroup.gnutella.xml.LimeXMLDocument", SerialXml.class.getName());
        this.addLookup("com.limegroup.gnutella.downloader.Interval", "org.limewire.collection.Interval");
        this.addLookup("com.limegroup.gnutella.util.IntervalSet", IntervalSet.class.getName());
        this.addLookup("com.limegroup.gnutella.BandwidthTrackerImpl", SerialBandwidthTrackerImpl.class.getName());
        this.addLookup("org.apache.commons.httpclient.URI", SerialOldURI.class.getName());
        this.addLookup("com.limegroup.bittorrent.BTMetaInfo", SerialBTMetaInfo.class.getName());
        this.addLookup("com.limegroup.bittorrent.BTMetaInfo$SerialKeys", SerialBTMetaInfo.SerialKeys.class.getName());
        this.addLookup("com.limegroup.bittorrent.TorrentFileSystem", SerialTorrentFileSystem.class.getName());
        this.addLookup("com.limegroup.bittorrent.disk.VerifyingFolder$SerialData", SerialDiskManagerData.class.getName());
        this.addLookup("com.limegroup.bittorrent.disk.VerifyingFolder$BlockRangeMap", SerialBlockRangeMap.class.getName());
    }

    static enum Version {
        Four16,
        Four14,
        Four11,
        Three0;

    }
}

