/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import org.limewire.core.settings.UploadSettings;
import org.limewire.util.Objects;

public abstract class AbstractAlternateLocation
implements AlternateLocation {
    protected final URN SHA1_URN;
    private String DISPLAY_STRING;
    protected volatile int hashCode = 0;
    protected volatile int _count = 0;
    private final Average legacy;
    private final Average ping;
    private final Average response;

    protected AbstractAlternateLocation(URN sha1) {
        this.SHA1_URN = Objects.nonNull(sha1, "sha1");
        this.legacy = new Average();
        this.ping = new Average();
        this.response = new Average();
    }

    @Override
    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    @Override
    public synchronized int getCount() {
        return this._count;
    }

    @Override
    public abstract boolean isDemoted();

    @Override
    public String httpStringValue() {
        if (this.DISPLAY_STRING == null) {
            this.DISPLAY_STRING = this.generateHTTPString();
        }
        return this.DISPLAY_STRING;
    }

    @Override
    public abstract RemoteFileDesc createRemoteFileDesc(long var1, RemoteFileDescFactory var3);

    @Override
    public abstract boolean isMe();

    @Override
    public synchronized void increment() {
        ++this._count;
    }

    abstract void demote();

    abstract void promote();

    @Override
    public abstract AlternateLocation createClone();

    @Override
    public synchronized void send(long now, int meshType) {
        switch (meshType) {
            case 1: {
                this.legacy.send(now);
                return;
            }
            case 0: {
                this.ping.send(now);
                return;
            }
            case 2: {
                this.response.send(now);
                return;
            }
        }
        throw new IllegalArgumentException("unknown mesh type");
    }

    @Override
    public synchronized boolean canBeSent(int meshType) {
        switch (meshType) {
            case 1: {
                if (!UploadSettings.EXPIRE_LEGACY.getValue()) {
                    return true;
                }
                return this.legacy.canBeSent(UploadSettings.LEGACY_BIAS.getValue(), UploadSettings.LEGACY_EXPIRATION_DAMPER.getValue());
            }
            case 0: {
                if (!UploadSettings.EXPIRE_PING.getValue()) {
                    return true;
                }
                return this.ping.canBeSent(UploadSettings.PING_BIAS.getValue(), UploadSettings.PING_EXPIRATION_DAMPER.getValue());
            }
            case 2: {
                if (!UploadSettings.EXPIRE_RESPONSE.getValue()) {
                    return true;
                }
                return this.response.canBeSent(UploadSettings.RESPONSE_BIAS.getValue(), UploadSettings.RESPONSE_EXPIRATION_DAMPER.getValue());
            }
        }
        throw new IllegalArgumentException("unknown mesh type");
    }

    @Override
    public synchronized boolean canBeSentAny() {
        return this.canBeSent(1) || this.canBeSent(0) || this.canBeSent(2);
    }

    synchronized void resetSent() {
        this.ping.reset();
        this.legacy.reset();
        this.response.reset();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractAlternateLocation)) {
            return false;
        }
        AbstractAlternateLocation other = (AbstractAlternateLocation)obj;
        return this.SHA1_URN.equals(other.SHA1_URN);
    }

    @Override
    public int compareTo(AlternateLocation other) {
        int ret = this._count - other.getCount();
        if (ret != 0) {
            return ret;
        }
        return ret;
    }

    protected abstract String generateHTTPString();

    public int hashCode() {
        return 629 + this.SHA1_URN.hashCode();
    }

    private static class Average {
        private int numTimes;
        private double average;
        private long lastSentTime;
        private double cachedTreshold = -1.0;

        private Average() {
        }

        public void send(long now) {
            if (this.lastSentTime == 0L) {
                this.lastSentTime = now;
            }
            this.average = (this.average * (double)this.numTimes + (double)(now - this.lastSentTime)) / (double)(++this.numTimes);
            this.lastSentTime = now;
            this.cachedTreshold = -1.0;
        }

        public boolean canBeSent(float bias, float damper) {
            if (this.numTimes < 2 || this.average == 0.0) {
                return true;
            }
            if (this.cachedTreshold == -1.0) {
                this.cachedTreshold = Math.abs(Math.log(this.average) / Math.log(damper));
            }
            return (double)this.numTimes < this.cachedTreshold * (double)bias;
        }

        public void reset() {
            this.numTimes = 0;
            this.average = 0.0;
            this.lastSentTime = 0L;
        }
    }
}

