/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.NetworkUpdateSanityChecker;
import com.limegroup.gnutella.ReplyHandler;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IP;
import org.limewire.nio.observer.Shutdownable;

@Singleton
public class NetworkUpdateSanityCheckerImpl
implements NetworkUpdateSanityChecker {
    private static final Set<NetworkUpdateSanityChecker.RequestType> allTypes = EnumSet.allOf(NetworkUpdateSanityChecker.RequestType.class);
    private static final Log LOG = LogFactory.getLog(NetworkUpdateSanityCheckerImpl.class);
    private static final int MAXIMUM_FAILURES = 20;
    private static final String MASK = "/255.255.0.0";
    private final Map<NetworkUpdateSanityChecker.RequestType, Map<ReplyHandler, Boolean>> requests = new HashMap<NetworkUpdateSanityChecker.RequestType, Map<ReplyHandler, Boolean>>(NetworkUpdateSanityChecker.RequestType.values().length);
    private final List<IP> failures = new ArrayList<IP>(20);
    private boolean finished = false;
    private final Set<NetworkUpdateSanityChecker.RequestType> successes = EnumSet.noneOf(NetworkUpdateSanityChecker.RequestType.class);
    private final Provider<ActivityCallback> activityCallback;

    @Inject
    public NetworkUpdateSanityCheckerImpl(Provider<ActivityCallback> activityCallback) {
        this.activityCallback = activityCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNewRequest(ReplyHandler handler, NetworkUpdateSanityChecker.RequestType type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding request to handler: " + handler);
        }
        Map<NetworkUpdateSanityChecker.RequestType, Map<ReplyHandler, Boolean>> map = this.requests;
        synchronized (map) {
            if (this.finished) {
                LOG.debug("Already reached maximum failure point, ignoring.");
                return;
            }
            this.addRequest(handler, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleValidResponse(ReplyHandler handler, NetworkUpdateSanityChecker.RequestType type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received valid response from handler: " + handler + "of type: " + (Object)((Object)type));
        }
        Map<NetworkUpdateSanityChecker.RequestType, Map<ReplyHandler, Boolean>> map = this.requests;
        synchronized (map) {
            if (!this.finished) {
                this.successes.add(type);
                if (this.successes.containsAll(allTypes)) {
                    LOG.debug("Received every kind of success!");
                    this.finished = true;
                    this.requests.clear();
                    this.failures.clear();
                } else {
                    this.removeRequest(handler, type);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInvalidResponse(ReplyHandler handler, NetworkUpdateSanityChecker.RequestType type) {
        Map<NetworkUpdateSanityChecker.RequestType, Map<ReplyHandler, Boolean>> map = this.requests;
        synchronized (map) {
            if (!this.finished && this.removeRequest(handler, type)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Had a request from handler, adding as failure... " + handler);
                }
                IP ip = new IP(handler.getAddress() + MASK);
                boolean contained = false;
                for (IP current : this.failures) {
                    if (!current.contains(ip)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Already had a failure from range: " + current + ", ignoring handler ip: " + ip);
                    }
                    contained = true;
                    break;
                }
                if (!contained) {
                    this.failures.add(ip);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Current failure size: " + this.failures.size());
                    }
                    if (this.failures.size() == 20) {
                        LOG.debug("Reached failure threshold!");
                        this.finished = true;
                        this.requests.clear();
                        this.failures.clear();
                        this.activityCallback.get().installationCorrupted();
                    }
                }
            }
        }
        if (handler instanceof Shutdownable) {
            ((Shutdownable)((Object)handler)).shutdown();
        }
    }

    private void addRequest(ReplyHandler handler, NetworkUpdateSanityChecker.RequestType type) {
        Map<ReplyHandler, Boolean> inner = this.requests.get((Object)type);
        if (inner == null) {
            inner = new WeakHashMap<ReplyHandler, Boolean>();
            this.requests.put(type, inner);
        }
        inner.put(handler, Boolean.TRUE);
    }

    private boolean removeRequest(ReplyHandler handler, NetworkUpdateSanityChecker.RequestType type) {
        Map<ReplyHandler, Boolean> inner = this.requests.get((Object)type);
        if (inner == null) {
            return false;
        }
        return inner.remove(handler) != null;
    }
}

