/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.search.workbooks;

import org.xmind.core.IBoundary;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;

public class ResultLevel {
    private ITopic rootTopic;
    private Object object;
    private boolean topicLabel;

    public ResultLevel(Object obj, boolean topicLabel) {
        this.object = obj;
        this.topicLabel = topicLabel;
        ISheet sheet = null;
        sheet = obj instanceof IBoundary ? ((IBoundary)this.object).getOwnedSheet() : (obj instanceof IRelationship ? ((IRelationship)this.object).getOwnedSheet() : ((ITopic)obj).getOwnedSheet());
        this.rootTopic = sheet.getRootTopic();
    }

    public Object getObject() {
        return this.object;
    }

    public String getName() {
        if (this.object instanceof IBoundary) {
            ITopic parent = ((IBoundary)this.object).getParent();
            return String.valueOf(((IBoundary)this.object).getTitleText()) + "/" + this.getName(parent);
        }
        if (this.object instanceof IRelationship) {
            return ((IRelationship)this.object).getTitleText();
        }
        ITopic topic = (ITopic)this.object;
        return this.getName(topic);
    }

    private String getName(ITopic topic) {
        if (topic.equals(this.rootTopic)) {
            return String.valueOf(topic.getTitleText()) + this.getTopicLabel(topic);
        }
        return this.getTopicPath(topic);
    }

    private String getTopicLabel(ITopic topic) {
        if (this.topicLabel) {
            String label = topic.getLabels().toArray(new String[0])[0];
            return "( " + label + " )";
        }
        return "";
    }

    private String getTopicPath(ITopic topic) {
        String text = topic.getTitleText();
        ITopic parent = topic.getParent();
        if (parent.equals(this.rootTopic)) {
            return String.valueOf(text) + this.getTopicLabel(topic) + "/" + parent.getTitleText();
        }
        return String.valueOf(text) + this.getTopicLabel(topic) + "/" + this.getTopicPath(parent);
    }

    public String toString() {
        return "ResultLavel#(" + this.object.toString() + ")";
    }
}

