/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tool;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.DraggingTool;
import org.xmind.gef.util.GEFUtils;

public abstract class ResizeTool
extends DraggingTool {
    protected static final Dimension TEMP_SIZE = new Dimension();
    private Rectangle initArea = new Rectangle();
    private Rectangle resultArea = null;
    private int orientation = -1;
    private boolean keepRatio = false;
    private Cursor cursor = null;

    public Rectangle getInitArea() {
        return this.initArea;
    }

    public void setInitArea(Rectangle rect) {
        this.initArea.setBounds(rect);
        this.resultArea = this.getInitArea().getCopy();
    }

    public Rectangle getResultArea() {
        return this.resultArea;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.cursor = GEFUtils.getPositionCursor(orientation);
    }

    public boolean isKeepRatio() {
        return this.keepRatio;
    }

    public void setKeepRatio(boolean keepRatio) {
        this.keepRatio = keepRatio;
    }

    protected void onDragging(Point cursorPosition, MouseDragEvent me) {
        this.ensureDragPositionVisible(cursorPosition, me);
        if (this.resultArea == null) {
            this.resultArea = this.getInitArea().getCopy();
        }
        this.updateArea(this.resultArea, cursorPosition, me);
    }

    protected abstract void updateArea(Rectangle var1, Point var2, MouseDragEvent var3);

    protected void updateAreaBounds(Rectangle area, Point cursorPosition) {
        Dimension size = TEMP_SIZE;
        if (this.orientation == 16) {
            if (this.isKeepRatio()) {
                this.keepRatio(size, cursorPosition.x - this.initArea.x, -1, this.initArea.width, this.initArea.height);
                area.y = this.initArea.y - (size.height - this.initArea.height) / 2;
                area.setSize(size);
            } else {
                area.width = this.constrainWidth(cursorPosition.x - this.initArea.x);
            }
        } else if (this.orientation == 8) {
            if (this.isKeepRatio()) {
                this.keepRatio(size, this.initArea.right() - cursorPosition.x, -1, this.initArea.width, this.initArea.height);
                area.y = this.initArea.y - (size.height - this.initArea.height) / 2;
                area.setSize(size);
            } else {
                area.width = this.constrainWidth(this.initArea.right() - cursorPosition.x);
            }
            area.x = this.initArea.right() - area.width;
        } else if (this.orientation == 4) {
            if (this.isKeepRatio()) {
                this.keepRatio(size, -1, cursorPosition.y - this.initArea.y, this.initArea.width, this.initArea.height);
                area.x = this.initArea.x - (size.width - this.initArea.width) / 2;
                area.setSize(size);
            } else {
                area.height = this.constrainHeight(cursorPosition.y - this.initArea.y);
            }
        } else if (this.orientation == 1) {
            if (this.isKeepRatio()) {
                this.keepRatio(size, -1, this.initArea.bottom() - cursorPosition.y, this.initArea.width, this.initArea.height);
                area.x = this.initArea.x - (size.width - this.initArea.width) / 2;
                area.setSize(size);
            } else {
                area.height = this.constrainHeight(this.initArea.bottom() - cursorPosition.y);
            }
            area.y = this.initArea.bottom() - area.height;
        } else if (this.orientation == 20) {
            if (this.isKeepRatio()) {
                this.keepRatio(size, cursorPosition.x - this.initArea.x, cursorPosition.y - this.initArea.y, this.initArea.width, this.initArea.height);
                area.setSize(size);
            } else {
                area.width = this.constrainWidth(cursorPosition.x - this.initArea.x);
                area.height = this.constrainHeight(cursorPosition.y - this.initArea.y);
            }
        } else if (this.orientation == 12) {
            if (this.isKeepRatio()) {
                this.keepRatio(size, this.initArea.right() - cursorPosition.x, cursorPosition.y - this.initArea.y, this.initArea.width, this.initArea.height);
                area.setSize(size);
            } else {
                area.width = this.constrainWidth(this.initArea.right() - cursorPosition.x);
                area.height = this.constrainHeight(cursorPosition.y - this.initArea.y);
            }
            area.x = this.initArea.right() - area.width;
        } else if (this.orientation == 9) {
            if (this.isKeepRatio()) {
                this.keepRatio(size, this.initArea.right() - cursorPosition.x, this.initArea.bottom() - cursorPosition.y, this.initArea.width, this.initArea.height);
                area.setSize(size);
            } else {
                area.width = this.constrainWidth(this.initArea.right() - cursorPosition.x);
                area.height = this.constrainHeight(this.initArea.bottom() - cursorPosition.y);
            }
            area.x = this.initArea.right() - area.width;
            area.y = this.initArea.bottom() - area.height;
        } else if (this.orientation == 17) {
            if (this.isKeepRatio()) {
                this.keepRatio(size, cursorPosition.x - this.initArea.x, this.initArea.bottom() - cursorPosition.y, this.initArea.width, this.initArea.height);
                area.setSize(size);
            } else {
                area.width = this.constrainWidth(cursorPosition.x - this.initArea.x);
                area.height = this.constrainHeight(this.initArea.bottom() - cursorPosition.y);
            }
            area.y = this.initArea.bottom() - area.height;
        }
    }

    protected void keepRatio(Dimension result, int w, int h, int initW, int initH) {
        result.width = w;
        result.height = h;
    }

    protected int constrainWidth(int w) {
        return w;
    }

    protected int constrainHeight(int h) {
        return h;
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        return this.cursor;
    }
}

