/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.ZoomObject;

public class ZoomManager
extends ZoomObject {
    private double max;
    private double min;
    private double scale = 1.0;

    public ZoomManager() {
        this(0.5, 2.0);
    }

    public ZoomManager(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public void setConstraints(double min, double max) {
        this.min = min;
        this.max = max;
        this.setScale(this.getScale());
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        scale = Math.min(this.getMax(), Math.max(this.getMin(), scale));
        this.internalSetScale(scale);
    }

    private void internalSetScale(double scale) {
        double oldScale = this.getScale();
        if (scale == oldScale) {
            return;
        }
        this.scale = scale;
        this.fireScaleChanged(oldScale, this.getScale());
    }

    public void zoomIn() {
        double scale = this.getScale();
        scale = scale >= 1.0 && scale < 1.2 ? ZoomManager.forceMultiple(scale + 0.2, 0.2) : (scale < 1.0 ? Math.min(1.0, ZoomManager.forceMultiple(scale + 0.1, 0.1)) : ZoomManager.forceMultiple(scale + 0.5, 0.5));
        this.setScale(scale);
    }

    public void zoomOut() {
        double scale = this.getScale();
        scale = scale <= 1.0 ? ZoomManager.forceMultiple(scale + 0.09, 0.1) - 0.1 : (scale > 1.0 && scale <= 1.2 ? ZoomManager.forceMultiple(scale + 0.19, 0.2) - 0.2 : Math.max(1.2, ZoomManager.forceMultiple(scale + 0.49, 0.5) - 0.5));
        this.setScale(scale);
    }

    private static double forceMultiple(double a, double m) {
        int x = (int)Math.round(a * 100.0);
        int y = (int)Math.round(m * 100.0);
        int d = x / y;
        double tmp = (double)d * m;
        tmp = (double)((int)(tmp * 100.0)) / 100.0;
        return tmp;
    }

    public void actualSize() {
        this.setScale(1.0);
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public void fitScale(Dimension box, Dimension client) {
        this.fitScale(box, client, -1.0, -1.0);
    }

    private double calculateFitScale(Dimension box, Dimension client) {
        return Math.min((double)box.width * 1.0 / (double)client.width, (double)box.height * 1.0 / (double)client.height);
    }

    public void fitScale(Dimension box, Dimension client, double min, double max) {
        double scale = this.calculateFitScale(box, client);
        if (min > max) {
            double t = max;
            max = min;
            min = t;
        }
        if (min > 0.0 && scale < min) {
            scale = this.getScale() > min ? this.getScale() : min;
        }
        if (max > 0.0 && scale > max) {
            scale = this.getScale() < max ? this.getScale() : max;
        }
        this.setScale(scale);
    }

    public Dimension getScaled(Dimension d) {
        return d.getScaled(this.getScale());
    }

    public Point getScaled(Point p) {
        return p.getScaled(this.getScale());
    }

    public Rectangle getScaled(Rectangle r) {
        return r.getCopy().scale(this.getScale());
    }

    public Dimension getAntiScaled(Dimension d) {
        return d.getScaled(1.0 / this.getScale());
    }

    public Point getAntiScaled(Point p) {
        return p.getScaled(1.0 / this.getScale());
    }

    public Rectangle getAntiScaled(Rectangle r) {
        return r.getCopy().scale(1.0 / this.getScale());
    }
}

