/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.ui.gantt2.gefext.IFullHorizontalFigure;
import org.xmind.ui.gantt2.gefext.IFullVerticalFigure;

public class BackgroundLayout
extends AbstractLayout {
    public static final Object CONSTRAINT_SELECTION = "selection";
    protected static final Rectangle AREA = new Rectangle();
    protected static final Rectangle RECT = new Rectangle();
    private IFigure contents;
    private List<IFullHorizontalFigure> horizontalBars = new ArrayList<IFullHorizontalFigure>();
    private List<IFullVerticalFigure> verticalBars = new ArrayList<IFullVerticalFigure>();

    public IFigure getContents() {
        return this.contents;
    }

    public void setContents(IFigure contents) {
        this.contents = contents;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Rectangle area = this.getContentsArea(container);
        return area.getSize();
    }

    public void setConstraint(IFigure child, Object constraint) {
        if (CONSTRAINT_SELECTION.equals(constraint)) {
            if (child instanceof IFullHorizontalFigure) {
                this.horizontalBars.add((IFullHorizontalFigure)child);
            }
            if (child instanceof IFullVerticalFigure) {
                this.verticalBars.add((IFullVerticalFigure)child);
            }
        } else {
            super.setConstraint(child, constraint);
        }
    }

    public void remove(IFigure child) {
        super.remove(child);
        this.horizontalBars.remove(child);
        this.verticalBars.remove(child);
    }

    public void layout(IFigure container) {
        Rectangle contentsArea = this.getContentsArea(container);
        Viewport viewport = this.getViewport(container);
        Rectangle viewportArea = viewport != null ? viewport.getBounds() : contentsArea;
        int left = Math.min(viewportArea.x, contentsArea.x);
        int top = Math.min(viewportArea.y, contentsArea.y);
        int width = Math.max(viewportArea.x + viewportArea.width, contentsArea.x + contentsArea.width) - left;
        int height = Math.max(viewportArea.y + viewportArea.height, contentsArea.y + contentsArea.height) - top;
        this.layoutChildren(contentsArea, viewportArea, left, top, width, height);
    }

    protected void layoutChildren(Rectangle contentsArea, Rectangle viewportArea, int left, int top, int width, int height) {
        Rectangle r = RECT;
        for (IFullHorizontalFigure iFullHorizontalFigure : this.horizontalBars) {
            r.x = left;
            r.y = iFullHorizontalFigure.getY();
            r.width = width;
            r.height = iFullHorizontalFigure.getHeight();
            iFullHorizontalFigure.setBounds(r);
        }
        for (IFullVerticalFigure iFullVerticalFigure : this.verticalBars) {
            r.x = iFullVerticalFigure.getX();
            r.y = top;
            r.width = iFullVerticalFigure.getWidth();
            r.height = height;
            iFullVerticalFigure.setBounds(r);
        }
    }

    protected Viewport getViewport(IFigure figure) {
        if (figure == null) {
            return null;
        }
        if (figure instanceof Viewport) {
            return (Viewport)figure;
        }
        return this.getViewport(figure.getParent());
    }

    protected Rectangle getContentsArea(IFigure container) {
        Rectangle r = AREA;
        if (this.contents != null) {
            if (this.contents instanceof FreeformFigure) {
                r.setBounds(((FreeformFigure)this.contents).getFreeformExtent());
            } else {
                r.setBounds(this.contents.getBounds());
            }
        } else {
            container.getClientArea(r);
        }
        return r;
    }
}

