/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.command.remote.lan.dnssd;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.xmind.core.internal.command.remote.lan.LANRemoteCommandPlugin;

public class AsyncQueuedExecutor
implements Executor {
    private Thread thread;
    private Queue<Runnable> taskQueue = new ConcurrentLinkedQueue<Runnable>();

    public AsyncQueuedExecutor(String threadName) {
        this.thread = new Thread(new Runnable(){

            public void run() {
                AsyncQueuedExecutor.this.mainLoop();
            }
        }, threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AsyncQueuedExecutor asyncQueuedExecutor = this;
        synchronized (asyncQueuedExecutor) {
            Thread theThread = this.thread;
            this.taskQueue.clear();
            this.thread = null;
            if (theThread != null) {
                theThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable task) {
        AsyncQueuedExecutor asyncQueuedExecutor = this;
        synchronized (asyncQueuedExecutor) {
            if (this.thread == null) {
                return;
            }
            this.taskQueue.offer(task);
        }
    }

    private void mainLoop() {
        try {
            while (this.thread != null) {
                Runnable task = this.taskQueue.poll();
                if (task != null) {
                    try {
                        task.run();
                    }
                    catch (Throwable e) {
                        this.handleTaskException(task, e);
                    }
                }
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void handleTaskException(Runnable task, Throwable e) {
        LANRemoteCommandPlugin.log(null, e);
    }
}

