/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.security;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.xmind.core.CoreException;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IFileEntry;
import org.xmind.core.internal.security.Base64;
import org.xmind.core.internal.security.BlockCipherInputStream;
import org.xmind.core.internal.security.BlockCipherOutputStream;
import org.xmind.core.internal.security.ChecksumInputStream;
import org.xmind.core.internal.security.ChecksumOutputStream;
import org.xmind.core.internal.security.ISecurityProvider;

public final class BouncyCastleSecurityProvider
implements ISecurityProvider {
    private static final String ALGORITHM_NAME = "AES/CBC/PKCS5Padding";
    private static final String KEY_DERIVATION_ALGORITHM_NAME = "PKCS12";
    private static Random random = null;

    private boolean needChecksum(IEncryptionData encData) {
        IFileEntry entry = encData.getFileEntry();
        if (entry != null) {
            String path = entry.getPath();
            return this.needChecksum(path);
        }
        return false;
    }

    private boolean needChecksum(String entryPath) {
        return "content.xml".equals(entryPath) || "meta.xml".equals(entryPath) || "styles.xml".equals(entryPath) || "markers/markerSheet.xml".equals(entryPath);
    }

    public void initializeEncryptionData(IEncryptionData encData) {
        if (this.needChecksum(encData)) {
            encData.setChecksumType("MD5");
        }
        encData.setAttribute(ALGORITHM_NAME, new String[]{"algorithm", "algorithm-name"});
        encData.setAttribute(KEY_DERIVATION_ALGORITHM_NAME, new String[]{"key-derivation", "key-derivation-name"});
        encData.setAttribute(BouncyCastleSecurityProvider.generateSalt(), new String[]{"key-derivation", "salt"});
        encData.setAttribute("1024", new String[]{"key-derivation", "iteration-count"});
    }

    private void checkEncryptionData(IEncryptionData encData) throws CoreException {
        String algoName = encData.getAttribute(new String[]{"algorithm", "algorithm-name"});
        if (algoName == null || !ALGORITHM_NAME.equals(algoName)) {
            throw new CoreException(16);
        }
        String keyAlgoName = encData.getAttribute(new String[]{"key-derivation", "key-derivation-name"});
        if (keyAlgoName == null || !KEY_DERIVATION_ALGORITHM_NAME.equals(keyAlgoName)) {
            throw new CoreException(16);
        }
    }

    private int getIterationCount(IEncryptionData encData) {
        return encData.getIntAttribute(1024, new String[]{"key-derivation", "iteration-count"});
    }

    private byte[] getSalt(IEncryptionData encData) throws CoreException {
        String saltString = encData.getAttribute(new String[]{"key-derivation", "salt"});
        if (saltString == null) {
            throw new CoreException(16);
        }
        return Base64.base64ToByteArray(saltString);
    }

    public OutputStream createPasswordProtectedOutputStream(OutputStream output, boolean encrypt, IEncryptionData encData, String password) throws CoreException {
        BufferedBlockCipher cipher = this.createCipher(encrypt, encData, password);
        FilterOutputStream out = new BlockCipherOutputStream(output, cipher);
        if (encData.getChecksumType() != null) {
            out = new ChecksumOutputStream(out);
        }
        return out;
    }

    public InputStream createPasswordProtectedInputStream(InputStream input, boolean encrypt, IEncryptionData encData, String password) throws CoreException {
        BufferedBlockCipher cipher = this.createCipher(encrypt, encData, password);
        FilterInputStream in = new BlockCipherInputStream(input, cipher);
        if (encData.getChecksumType() != null) {
            in = new ChecksumInputStream(in);
        }
        return in;
    }

    private BufferedBlockCipher createCipher(boolean encrypt, IEncryptionData encData, String password) throws CoreException {
        this.checkEncryptionData(encData);
        PKCS12ParametersGenerator paramGen = new PKCS12ParametersGenerator((Digest)new MD5Digest());
        byte[] pwBytes = password == null ? new byte[]{} : PBEParametersGenerator.PKCS12PasswordToBytes((char[])password.toCharArray());
        paramGen.init(pwBytes, this.getSalt(encData), this.getIterationCount(encData));
        CipherParameters param = paramGen.generateDerivedParameters(128);
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
        cipher.init(encrypt, param);
        return cipher;
    }

    private static Random getRandom() {
        if (random == null) {
            random = new Random();
        }
        return random;
    }

    private static String generateSalt() {
        return Base64.byteArrayToBase64(BouncyCastleSecurityProvider.generateSaltBytes());
    }

    private static byte[] generateSaltBytes() {
        byte[] bytes = new byte[8];
        BouncyCastleSecurityProvider.getRandom().nextBytes(bytes);
        return bytes;
    }
}

