/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import java.util.List;
import org.xmind.core.IExtensionElement;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.ideafactory.IdeaFactoryMessages;
import org.xmind.ui.internal.ideafactory.IdeaUtils;

public class DeleteIdeaCommand
extends SourceCommand {
    private ITopic rootTopic;
    private ITopicExtensionElement deletedIdea;
    private ITopicExtensionElement parent;
    private int index = -1;
    private int inGroupIndex = -1;

    public DeleteIdeaCommand(ITopic rootTopic, ITopicExtensionElement deletedIdea) {
        super((Object)rootTopic);
        this.rootTopic = rootTopic;
        this.deletedIdea = deletedIdea;
        this.parent = (ITopicExtensionElement)deletedIdea.getParent();
        this.setLabel(IdeaFactoryMessages.DeleteIdeaCommand_LabelText);
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        if (this.index == -1) {
            List children = this.parent.getChildren("idea");
            this.index = children.indexOf(this.deletedIdea);
            List<ITopicExtensionElement> groupIdeas = IdeaUtils.getGroupIdeas(this.rootTopic, this.deletedIdea.getAttribute("group_id"));
            this.inGroupIndex = groupIdeas.indexOf(this.deletedIdea);
        }
        this.parent.deleteChild((IExtensionElement)this.deletedIdea);
        this.fireCoreEvent(this.rootTopic, "ideaDeleted");
        super.redo();
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        if (this.parent != null) {
            this.parent.addChild((IExtensionElement)this.deletedIdea, this.index);
            this.fireCoreEvent(this.rootTopic, "ideaAdded");
        }
        super.undo();
    }

    private void fireCoreEvent(ITopic topic, String eventType) {
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)topic, eventType, (Object)this.deletedIdea, this.inGroupIndex);
        }
    }
}

