/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.IRevision;
import org.xmind.core.IRevisionManager;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.plain.Revision;
import org.xmind.core.plain.Workbook;
import org.xmind.core.util.ReversedListIterator;

public class RevisionManager
implements IRevisionManager,
ICoreEventSource {
    private final Workbook ownerWorkbook;
    private final String resourceId;
    private final String contentType;
    private final List<IRevision> revisions;
    private int nextRevisionNumber;
    private boolean orphan;

    public RevisionManager(Workbook ownerWorkbook, String resourceId, String contentType) {
        this.ownerWorkbook = ownerWorkbook;
        this.resourceId = resourceId;
        this.contentType = contentType;
        this.revisions = new ArrayList<IRevision>();
        this.nextRevisionNumber = 1;
        this.orphan = true;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        return null;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public List<IRevision> getRevisions() {
        return Collections.unmodifiableList(this.revisions);
    }

    public List<IRevision> getRevisionsReversed() {
        ArrayList<IRevision> list = new ArrayList<IRevision>(this.revisions);
        Collections.reverse(list);
        return list;
    }

    public Iterator<IRevision> iterRevisions() {
        return Collections.unmodifiableList(this.revisions).iterator();
    }

    public Iterator<IRevision> iterRevisionsReversed() {
        return new ReversedListIterator<IRevision>(Collections.unmodifiableList(this.revisions));
    }

    public IRevision getRevision(int number) {
        for (IRevision r : this.revisions) {
            if (number != r.getRevisionNumber()) continue;
            return r;
        }
        return null;
    }

    public IRevision getLatestRevision() {
        IRevision latest = null;
        for (IRevision r : this.revisions) {
            if (latest == null) {
                latest = r;
                continue;
            }
            if (r.getRevisionNumber() <= latest.getRevisionNumber()) continue;
            latest = r;
        }
        return latest;
    }

    public int getNextRevisionNumber() {
        return this.nextRevisionNumber;
    }

    public IRevision addRevision(IAdaptable content) throws IOException, CoreException {
        return null;
    }

    public Object removeRevision(IRevision revision) {
        if (revision == null || revision.getOwnedWorkbook() != this.ownerWorkbook) {
            throw new IllegalArgumentException();
        }
        int index = this.revisions.indexOf(revision);
        if (index < 0) {
            return null;
        }
        this.revisions.remove(index);
        if (!this.isOrphan() && revision instanceof Revision) {
            ((Revision)revision).onOrphan();
        }
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, "revisionRemove", (Object)revision);
        return new RevisionRemovalToken(this, revision, index);
    }

    public void restoreRevision(IRevision revision, Object removal) {
        if (revision == null || revision.getOwnedWorkbook() != this.ownerWorkbook) {
            throw new IllegalArgumentException();
        }
        if (!(removal instanceof RevisionRemovalToken)) {
            throw new IllegalArgumentException();
        }
        RevisionRemovalToken token = (RevisionRemovalToken)removal;
        if (token.getManager() != this || token.getRevision() != revision) {
            throw new IllegalArgumentException();
        }
        this.revisions.add(token.getIndex(), revision);
        if (!this.isOrphan() && revision instanceof Revision) {
            ((Revision)revision).onParented();
        }
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, "revisionAdd", (Object)revision);
    }

    public boolean hasRevisions() {
        return !this.revisions.isEmpty();
    }

    protected void onParented() {
        this.orphan = false;
        for (IRevision r : this.revisions) {
            if (!(r instanceof Revision)) continue;
            ((Revision)r).onParented();
        }
    }

    protected void onOrphan() {
        for (IRevision r : this.revisions) {
            if (!(r instanceof Revision)) continue;
            ((Revision)r).onOrphan();
        }
        this.orphan = true;
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.ownerWorkbook.getCoreEventSupport();
    }

    private static class RevisionRemovalToken {
        private final RevisionManager manager;
        private final IRevision revision;
        private final int index;

        public RevisionRemovalToken(RevisionManager manager, IRevision revision, int index) {
            this.manager = manager;
            this.revision = revision;
            this.index = index;
        }

        public RevisionManager getManager() {
            return this.manager;
        }

        public IRevision getRevision() {
            return this.revision;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

