/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.xmind.core.Core;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.taskinfo.AssigneeSheet;
import org.xmind.ui.internal.taskinfo.AssigneeSheetBuilder;
import org.xmind.ui.util.Logger;

public class AssigneeSheetManager {
    private static AssigneeSheetManager instance = null;
    private static final String PATH_ASSIGNEE = "assignees/";
    private static final String ASSIGNEE_SHEET_XML = "assignees.xml";
    private AssigneeSheet assigneeSheet = null;
    private AssigneeSheetBuilder builder = null;

    private AssigneeSheetManager() {
    }

    public AssigneeSheet getAssigneeSheet() {
        if (this.assigneeSheet == null) {
            this.assigneeSheet = this.createAssigneeSheet();
        }
        return this.assigneeSheet;
    }

    private AssigneeSheet createAssigneeSheet() {
        File file;
        String path = Core.getWorkspace().getAbsolutePath("assignees/assignees.xml");
        if (path != null && (file = new File(path)).exists()) {
            try {
                return this.getAssigneeSheetBuilder().loadFromFile(file);
            }
            catch (Exception e) {
                Logger.log((Throwable)e, (String)("Failed to load assignee from: " + file));
            }
        }
        return this.getAssigneeSheetBuilder().createAssigneeSheet();
    }

    private synchronized AssigneeSheetBuilder getAssigneeSheetBuilder() {
        if (this.builder == null) {
            this.builder = new AssigneeSheetBuilder();
        }
        return this.builder;
    }

    public void saveAssigneeSheet() {
        block13: {
            if (this.assigneeSheet != null) {
                String path = Core.getWorkspace().getAbsolutePath("assignees/assignees.xml");
                File file = FileUtils.ensureFileParent((File)new File(path));
                FileOutputStream out = null;
                try {
                    try {
                        out = new FileOutputStream(file);
                        this.assigneeSheet.save(out);
                    }
                    catch (Exception e) {
                        Logger.log((Throwable)e);
                        if (out == null) break block13;
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            Logger.log((Throwable)e2);
                        }
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            Logger.log((Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public static AssigneeSheetManager getInstance() {
        if (instance == null) {
            instance = new AssigneeSheetManager();
        }
        return instance;
    }
}

