/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.jobs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.cathy.internal.WorkbenchMessages;

public abstract class AbstractCheckFilesJob
extends Job {
    private final IWorkbench workbench;
    private List<IEditorInput> editorsToOpen;

    public AbstractCheckFilesJob(IWorkbench workbench, String jobName) {
        super(jobName);
        this.workbench = workbench;
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                AbstractCheckFilesJob.this.prepare();
            }

            public void done(IJobChangeEvent event) {
                AbstractCheckFilesJob.this.finish();
            }
        });
    }

    protected void prepare() {
        this.editorsToOpen = null;
    }

    protected void finish() {
        this.editorsToOpen = null;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    protected void addEditorToOpen(IEditorInput input) {
        if (this.editorsToOpen == null) {
            this.editorsToOpen = new ArrayList<IEditorInput>();
        }
        this.editorsToOpen.add(input);
    }

    protected void openEditors(IProgressMonitor monitor, String taskName, int ticks, boolean activate) {
        if (this.editorsToOpen != null && !this.editorsToOpen.isEmpty()) {
            monitor = new SubProgressMonitor(monitor, ticks);
            monitor.beginTask(taskName, this.editorsToOpen.size());
            this.openEditors(monitor, this.editorsToOpen, activate);
            monitor.done();
        } else {
            monitor.worked(ticks);
        }
    }

    protected void openEditors(IProgressMonitor monitor, List<IEditorInput> editorInputs, boolean activate) {
        for (IEditorInput input : editorInputs) {
            monitor.subTask(input.getName());
            IEditorPart editor = this.openEditor(input, activate);
            if (editor != null) {
                activate = false;
            }
            monitor.worked(1);
        }
    }

    protected IEditorPart openEditor(final IEditorInput input, final boolean activate) {
        if (input == null) {
            return null;
        }
        Display display = this.workbench.getDisplay();
        if (display == null) {
            return null;
        }
        final IEditorPart[] result = new IEditorPart[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = AbstractCheckFilesJob.this.getPrimaryWindow();
                if (window == null) {
                    return;
                }
                final IWorkbenchPage page = window.getActivePage();
                if (page != null) {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(NLS.bind((String)WorkbenchMessages.CheckOpenFilesJob_FailsToOpen_message, (Object)input.getName())){

                        public void run() throws Exception {
                            result[0] = page.openEditor(input, "org.xmind.ui.MindMapEditor", activate);
                        }
                    });
                }
            }
        });
        return result[0];
    }

    private IWorkbenchWindow getPrimaryWindow() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window == null && (windows = this.workbench.getWorkbenchWindows()) != null && windows.length > 0) {
            window = windows[0];
        }
        return window;
    }
}

