/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.UIPlugin;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.CathyWorkbenchWindowAdvisor;
import org.xmind.cathy.internal.Log;
import org.xmind.cathy.internal.OpenDocumentQueue;
import org.xmind.cathy.internal.StartUpProcess;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.cathy.internal.jobs.OpenFilesJob;
import org.xmind.core.internal.InternalCore;
import org.xmind.core.licensing.ILicenseAgent;
import org.xmind.core.licensing.ILicenseChangedListener;
import org.xmind.core.licensing.ILicenseKeyHeader;
import org.xmind.gef.ui.editor.IEditingContext;
import org.xmind.ui.internal.PasswordProvider;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.AbstractWorkbookRef;
import org.xmind.ui.internal.editor.DefaultMindMapPreviewGenerator;
import org.xmind.ui.internal.editor.IMindMapPreviewGenerator;
import org.xmind.ui.internal.editor.IPasswordProvider;

public class CathyWorkbenchAdvisor
extends WorkbenchAdvisor
implements ILicenseChangedListener {
    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new CathyWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return "org.xmind.ui.perspective.mindmapping";
    }

    public String getMainPreferencePageId() {
        return "org.xmind.ui.prefPage.General";
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        configurer.setExitOnLastWindowClose(true);
    }

    public void preStartup() {
        super.preStartup();
        CathyPlugin.getDefault().getLicenseAgent().addLicenseChangedListener((ILicenseChangedListener)this);
        this.licenseChanged(CathyPlugin.getDefault().getLicenseAgent());
        UIPlugin.getDefault().getPreferenceStore().setValue("SHOW_TRADITIONAL_STYLE_TABS", true);
    }

    public void postStartup() {
        super.postStartup();
        IWorkbench workbench = this.getWorkbenchConfigurer().getWorkbench();
        AbstractWorkbookRef.setDefaultEditingContext((IEditingContext)this.createDefaultEditingContext(workbench));
        new StartUpProcess(workbench).startUp();
    }

    private IEditingContext createDefaultEditingContext(IWorkbench workbench) {
        DefaultMindMapPreviewGenerator previewGenerator = new DefaultMindMapPreviewGenerator(workbench.getDisplay());
        PasswordProvider passwordProvider = new PasswordProvider();
        return new IEditingContext((IMindMapPreviewGenerator)previewGenerator, (IPasswordProvider)passwordProvider, workbench){
            private final /* synthetic */ IMindMapPreviewGenerator val$previewGenerator;
            private final /* synthetic */ IPasswordProvider val$passwordProvider;
            private final /* synthetic */ IWorkbench val$workbench;
            {
                this.val$previewGenerator = iMindMapPreviewGenerator;
                this.val$passwordProvider = iPasswordProvider;
                this.val$workbench = iWorkbench;
            }

            public <T> T getAdapter(Class<T> adapter) {
                if (IMindMapPreviewGenerator.class.equals(adapter)) {
                    return adapter.cast(this.val$previewGenerator);
                }
                if (IPasswordProvider.class.equals(adapter)) {
                    return adapter.cast(this.val$passwordProvider);
                }
                Object result = this.val$workbench.getService(adapter);
                if (result != null) {
                    return (T)result;
                }
                result = this.val$workbench.getAdapter(adapter);
                if (result != null) {
                    return (T)result;
                }
                return (T)result;
            }
        };
    }

    public void postShutdown() {
        CathyPlugin.getDefault().getLicenseAgent().removeLicenseChangedListener((ILicenseChangedListener)this);
        AbstractWorkbookRef.setDefaultEditingContext(null);
        super.postShutdown();
    }

    public boolean preShutdown() {
        boolean readyToShutdown = super.preShutdown();
        if (readyToShutdown) {
            readyToShutdown = this.saveAllEditorsOnClose();
        }
        return readyToShutdown;
    }

    private boolean saveAllEditorsOnClose() {
        IWorkbenchWindow[] windows;
        IWorkbench workbench = this.getWorkbenchConfigurer().getWorkbench();
        final ArrayList<IEditorReference> unClosedEditorRefs = new ArrayList<IEditorReference>();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = window.getActivePage();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n3 = iEditorReferenceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference editorRef = iEditorReferenceArray[n4];
                unClosedEditorRefs.add(editorRef);
                IEditorPart editor = editorRef.getEditor(false);
                if (editor != null && editor.isDirty()) {
                    int answer = this.promptToSaveOnClose(window, page, editor);
                    if (answer == 2) {
                        return false;
                    }
                    if (answer == 0 && !this.doSaveEditor(window, editor)) {
                        return false;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                XMLMemento mem = CathyWorkbenchAdvisor.this.recordEditorsState(unClosedEditorRefs);
                CathyWorkbenchAdvisor.this.saveMementoToFile(mem);
            }
        });
        return this.closeAllEditors();
    }

    private XMLMemento recordEditorsState(ArrayList<IEditorReference> editorRefs) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"xmind");
        this.saveEditorsState((IMemento)memento, editorRefs);
        return memento;
    }

    private void saveEditorsState(IMemento memento, ArrayList<IEditorReference> editorRefs) {
        IEditorPart activeEditor = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null) {
            activeEditor = window.getActivePage().getActiveEditor();
        }
        IMemento childrenMemento = memento.createChild("editors");
        if (!editorRefs.isEmpty()) {
            for (IEditorReference ref : editorRefs) {
                IEditorPart editor = ref.getEditor(false);
                if (editor == null) continue;
                IMemento editorMemento = childrenMemento.createChild("editor");
                editorMemento.putBoolean("activePart", editor == activeEditor);
                IPersistable editorPersistable = CathyPlugin.getAdapter(editor, IPersistable.class);
                if (editorPersistable != null) {
                    editorPersistable.saveState(editorMemento);
                }
                IEditorInput input = editor.getEditorInput();
                IMemento inputMemento = editorMemento.createChild("input");
                IPersistableElement inputPersistable = CathyPlugin.getAdapter(input, IPersistableElement.class);
                if (inputPersistable == null) continue;
                inputMemento.putString("factoryID", inputPersistable.getFactoryId());
                inputPersistable.saveState(inputMemento);
            }
        }
    }

    private boolean saveMementoToFile(XMLMemento memento) {
        File stateFile = this.getEditorsStateFile();
        if (stateFile == null) {
            return false;
        }
        try {
            FileOutputStream stream = new FileOutputStream(stateFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
            memento.save((Writer)writer);
            writer.close();
        }
        catch (IOException iOException) {
            stateFile.delete();
            return false;
        }
        return true;
    }

    private File getEditorsStateFile() {
        IPath path = WorkbenchPlugin.getDefault().getDataLocation();
        if (path == null) {
            return null;
        }
        path = path.append("XMind_Editors.xml");
        return path.toFile();
    }

    private int promptToSaveOnClose(IWorkbenchWindow window, IWorkbenchPage page, IEditorPart editor) {
        int answer;
        if (editor instanceof ISaveablePart2 && (answer = ((ISaveablePart2)editor).promptToSaveOnClose()) != 3) {
            return answer;
        }
        page.activate((IWorkbenchPart)editor);
        MessageDialog dialog = new MessageDialog(window.getShell(), DialogMessages.Save_title, null, NLS.bind((String)WorkbenchMessages.PromptSaveEditorOnClosing_message, (Object)editor.getTitle()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        int answerIndex = dialog.open();
        switch (answerIndex) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    private boolean doSaveEditor(IWorkbenchWindow window, final IEditorPart editor) {
        final boolean[] saved = new boolean[]{false};
        window.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        NullProgressMonitor monitor = new NullProgressMonitor();
                        if (InternalCore.DEBUG_WORKBOOK_SAVE) {
                            CathyPlugin.log("CathyWorkbenchAdvisor: About to save workbook on workbench close: " + editor.getEditorInput().toString());
                        }
                        editor.doSave((IProgressMonitor)monitor);
                        if (!monitor.isCanceled()) {
                            saved[0] = true;
                        } else if (InternalCore.DEBUG_WORKBOOK_SAVE) {
                            CathyPlugin.log("CathyWorkbenchAdvisor: Finished saving workbook on workbench close: " + editor.getEditorInput().toString());
                        }
                    }
                });
            }
        });
        return saved[0];
    }

    private boolean closeAllEditors() {
        boolean closed = false;
        IWorkbench workbench = this.getWorkbenchConfigurer().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            closed |= window.getActivePage().closeAllEditors(false);
            ++n2;
        }
        return closed;
    }

    public void licenseChanged(ILicenseAgent agent) {
        int type = agent.getLicenseType();
        ILicenseKeyHeader header = agent.getLicenseKeyHeader();
        String brandingVersion = System.getProperty("org.xmind.product.brandingVersion", "");
        String licenseType = (type & 4) != 0 ? NLS.bind((String)WorkbenchMessages.About_ProTitle, (Object)brandingVersion) : ((type & 8) != 0 ? NLS.bind((String)WorkbenchMessages.About_PlusTitle, (Object)brandingVersion) : ((type & 2) != 0 ? WorkbenchMessages.About_ProSubscriptionTitle : null));
        if (header != null && ((type & 8) != 0 || (type & 4) != 0)) {
            String licenseeType = header.getLicenseeType();
            if ("F".equals(licenseeType)) {
                licenseType = NLS.bind((String)"{0} (Family License)", (Object)licenseType);
            } else if ("E".equals(licenseeType)) {
                licenseType = NLS.bind((String)"{0} (Academia License)", (Object)licenseType);
            } else if ("G".equals(licenseeType)) {
                licenseType = NLS.bind((String)"{0} (Gov/NPO License)", (Object)licenseType);
            } else if ("T".equals(licenseeType) || "1".equals(licenseeType) || "2".equals(licenseeType)) {
                licenseType = NLS.bind((String)"{0} (Team License)", (Object)licenseType);
            } else if ("V".equals(licenseeType)) {
                licenseType = NLS.bind((String)"{0} (Volume License)", (Object)licenseType);
            }
        }
        licenseType = licenseType == null ? WorkbenchMessages.About_LicenseType_Unactivated : NLS.bind((String)WorkbenchMessages.About_LicenseTypePattern, (Object)licenseType);
        System.setProperty("org.xmind.product.license.type", licenseType);
        String name = agent.getLicenseeName();
        name = name != null && !"".equals(name) ? NLS.bind((String)WorkbenchMessages.About_LicensedTo, (Object)name) : "";
        System.setProperty("org.xmind.product.license.licensee", name);
    }

    public void eventLoopIdle(Display display) {
        Object[] paths = OpenDocumentQueue.getInstance().drain();
        if (paths.length > 0) {
            Shell shell;
            CathyPlugin.log("Ready to open files: " + Arrays.toString(paths));
            this.openFiles((String[])paths);
            IWorkbenchWindow window = this.getWorkbenchConfigurer().getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (shell = window.getShell()) != null && !shell.isDisposed()) {
                shell.forceActive();
            }
        } else {
            super.eventLoopIdle(display);
        }
    }

    private void openFiles(String[] paths) {
        OpenFilesJob job = new OpenFilesJob(this.getWorkbenchConfigurer().getWorkbench(), WorkbenchMessages.CheckOpenFilesJob_CheckFiles_name, Arrays.asList(paths));
        job.setRule(Log.get(".opening"));
        job.schedule();
    }
}

