/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.color.ColorPicker;
import org.xmind.ui.color.ColorPickerConfigurer;
import org.xmind.ui.color.ColorSelection;
import org.xmind.ui.properties.PropertyEditor;
import org.xmind.ui.resources.ColorUtils;

public class ColorPropertyEditor
extends PropertyEditor {
    private static final int DEFAULT_TEXT_STYLE = 2052;
    private static final String COLOR_NONE_VALUE = "none";
    private int textStyle;
    private ColorPickerConfigurer configurer;
    private Text text;
    private ToolBarManager toolBar;
    private ColorPicker picker;
    private boolean modifying = false;

    public ColorPropertyEditor() {
        this(2052, new ColorPickerConfigurer());
    }

    public ColorPropertyEditor(ColorPickerConfigurer colorPickerConfigurer) {
        this(2052, colorPickerConfigurer);
    }

    public ColorPropertyEditor(int textStyle, ColorPickerConfigurer colorPickerConfigurer) {
        Assert.isNotNull((Object)colorPickerConfigurer);
        this.textStyle = textStyle;
        this.configurer = colorPickerConfigurer;
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 3;
        composite.setLayout((Layout)layout);
        Control textControl = this.createText(composite);
        GridData textData = new GridData(4, 0x1000000, true, true);
        textData.widthHint = -1;
        textData.heightHint = -1;
        textControl.setLayoutData((Object)textData);
        Control toolBarControl = this.createToolBar(composite);
        GridData toolBarData = new GridData(4, 0x1000000, false, true);
        toolBarData.widthHint = -1;
        toolBarData.heightHint = -1;
        toolBarControl.setLayoutData((Object)toolBarData);
        return composite;
    }

    private Control createText(Composite parent) {
        this.text = new Text(parent, this.textStyle);
        this.text.setTextLimit(7);
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ColorPropertyEditor.this.text == null || ColorPropertyEditor.this.text.isDisposed()) {
                            return;
                        }
                        if (ColorPropertyEditor.this.isAncestorShell(ColorPropertyEditor.this.text.getShell(), Display.getCurrent().getActiveShell())) {
                            return;
                        }
                        ColorPropertyEditor.this.textEditingFinished();
                    }
                });
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    ColorPropertyEditor.this.fireCancelEditing();
                    e.doit = false;
                } else if (e.detail == 4) {
                    ColorPropertyEditor.this.textEditingFinished();
                    e.doit = false;
                }
            }
        });
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.keyCode == 27 && e.stateMask == 0) {
                    ColorPropertyEditor.this.fireCancelEditing();
                    e.doit = false;
                } else if (e.keyCode == 13) {
                    ColorPropertyEditor.this.textEditingFinished();
                    e.doit = false;
                } else {
                    char[] charArray;
                    if (ColorPropertyEditor.COLOR_NONE_VALUE.equals(e.text)) {
                        return;
                    }
                    char[] cArray = charArray = e.text.toCharArray();
                    int n = charArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean isValid;
                        char character = cArray[n2];
                        boolean bl = isValid = character == '#' || character >= 'A' && character <= 'F' || character >= 'a' && character <= 'f' || character >= '0' && character <= '9';
                        if (!isValid) {
                            e.doit = false;
                            return;
                        }
                        ++n2;
                    }
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ColorPropertyEditor.this.modifying) {
                    return;
                }
                String value = ColorPropertyEditor.this.text.getText();
                if (!(value != null && value.lastIndexOf(35) == 0 || ColorPropertyEditor.COLOR_NONE_VALUE.equals(value))) {
                    value = "";
                }
                ColorPropertyEditor.this.changeValue("".equals(value) ? null : value);
            }
        });
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    ColorPropertyEditor.this.textEditingFinished();
                    e.doit = false;
                }
            }
        });
        return this.text;
    }

    private boolean isAncestorShell(Shell ancestor, Shell shell) {
        if (ancestor == null || shell == null || shell == ancestor) {
            return false;
        }
        Composite parent = shell.getParent();
        if (parent == ancestor) {
            return true;
        }
        if (parent instanceof Shell) {
            return this.isAncestorShell(ancestor, (Shell)parent);
        }
        return false;
    }

    private void textEditingFinished() {
        String value = this.text.getText();
        if (!(value != null && value.length() == 7 || COLOR_NONE_VALUE.equals(value))) {
            this.text.setText("");
        }
        this.setValueToPicker(value);
        this.fireApplyEditorValue();
    }

    private Control createToolBar(Composite parent) {
        this.toolBar = new ToolBarManager();
        this.picker = new ColorPicker(this.configurer.getPopupStyle(), this.configurer.getPalette());
        this.configureColorPicker(this.picker);
        this.toolBar.add((IContributionItem)this.picker);
        this.toolBar.createControl(parent);
        return this.toolBar.getControl();
    }

    private void configureColorPicker(ColorPicker picker) {
        picker.setAutoColor(this.configurer.getAutoColor());
        picker.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                RGB color;
                ColorSelection selection = (ColorSelection)event.getSelection();
                Object value = selection.isNone() ? ColorPropertyEditor.this.configurer.getNoneValue() : (selection.isAutomatic() ? ColorPropertyEditor.this.configurer.getAutoValue() : ((color = selection.getColor()) == null ? null : ColorUtils.toString(color)));
                ColorPropertyEditor.this.setValueToText(value);
                ColorPropertyEditor.this.changeValue(value);
                ColorPropertyEditor.this.fireApplyEditorValue();
            }
        });
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setBackground(color);
        }
        if (this.toolBar != null && this.toolBar.getControl() != null && !this.toolBar.getControl().isDisposed()) {
            this.toolBar.getControl().setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setForeground(color);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setFont(font);
        }
    }

    @Override
    public void setFocus() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setFocus();
        } else {
            super.setFocus();
        }
    }

    @Override
    protected void activateWidget() {
        super.activateWidget();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ColorPropertyEditor.this.toolBar == null || ColorPropertyEditor.this.toolBar.getControl() == null || ColorPropertyEditor.this.toolBar.getControl().isDisposed()) {
                    return;
                }
                ColorPropertyEditor.this.picker.open();
            }
        });
    }

    @Override
    protected void setValueToWidget(Object value) {
        this.setValueToText(value);
        this.setValueToPicker(value);
    }

    private void setValueToText(Object value) {
        if (value instanceof String) {
            this.text.setText((String)value);
        } else if (value instanceof RGB) {
            this.text.setText(ColorUtils.toString((RGB)value));
        } else if (value == null) {
            this.text.setText("");
        } else {
            this.text.setText(value.toString());
        }
    }

    private void setValueToPicker(Object value) {
        RGB color;
        ColorSelection selection = this.configurer.isNoneValueSet() && (this.configurer.getNoneValue() == value || this.configurer.getNoneValue() != null && this.configurer.getNoneValue().equals(value)) ? new ColorSelection(2) : (this.configurer.isAutoValueSet() && (this.configurer.getAutoValue() == value || this.configurer.getAutoValue() != null && this.configurer.getAutoValue().equals(value)) ? new ColorSelection(1) : (value instanceof String ? ((color = ColorUtils.toRGB((String)value)) == null ? ColorSelection.EMPTY : new ColorSelection(color)) : (value instanceof RGB ? new ColorSelection((RGB)value) : ColorSelection.EMPTY)));
        this.picker.setSelection(selection);
    }
}

