/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.PageBook;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.views.ImageInspectorSection;
import org.xmind.ui.internal.views.InspectorSection;
import org.xmind.ui.internal.views.Messages;

public class InspectorViewer {
    private static final int PAGE_NO_CONTENT = 0;
    private static final int PAGE_CONTENT = 1;
    private IGraphicalViewer contributingViewer;
    private WidgetFactory factory;
    private PageBook pageBook;
    private Composite emptyPage;
    private Composite contentPage;
    private ScrolledForm contentForm;
    private List<InspectorSection> sections;
    private ImageInspectorSection imageSection;
    private boolean schedulingReflow = false;

    public void addSection(InspectorSection section) {
        if (section instanceof ImageInspectorSection) {
            this.imageSection = (ImageInspectorSection)section;
        }
        if (this.sections == null) {
            this.sections = new ArrayList<InspectorSection>();
        }
        this.sections.add(section);
    }

    public void createControl(Composite parent) {
        this.factory = new WidgetFactory(parent.getDisplay());
        this.factory.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        this.pageBook = new PageBook(parent, 0);
        this.pageBook.setBackground(parent.getDisplay().getSystemColor(25));
        this.pageBook.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InspectorViewer.this.handleDispose();
            }
        });
        this.createEmptyPage((Composite)this.pageBook);
        this.pageBook.showPage((Control)this.emptyPage);
    }

    private void createEmptyPage(Composite parent) {
        this.emptyPage = new Composite(parent, 0);
        this.emptyPage.setBackground(parent.getBackground());
        FillLayout layout = new FillLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        this.emptyPage.setLayout((Layout)layout);
        Label text = new Label(this.emptyPage, 64);
        text.setBackground(this.emptyPage.getBackground());
        text.setText(Messages.NoContent_message);
        final Color color = new Color((Device)parent.getDisplay(), 64, 64, 64);
        text.setForeground(color);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                color.dispose();
            }
        });
    }

    public IGraphicalViewer getContributingViewer() {
        return this.contributingViewer;
    }

    public void setContributingViewer(IGraphicalViewer contributedViewer) {
        IGraphicalViewer oldViewer = this.contributingViewer;
        this.contributingViewer = contributedViewer;
        this.contributingViewerChanged(oldViewer, contributedViewer);
    }

    private void contributingViewerChanged(IGraphicalViewer oldViewer, IGraphicalViewer newViewer) {
        if (this.sections != null) {
            for (InspectorSection section : this.sections) {
                section.setContributingViewer(newViewer);
            }
        }
        this.showPage(newViewer != null ? 1 : 0);
        if (this.schedulingReflow) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (InspectorViewer.this.contentPage != null && !InspectorViewer.this.contentPage.isDisposed()) {
                    InspectorViewer.this.contentPage.layout();
                }
                if (InspectorViewer.this.pageBook != null && InspectorViewer.this.pageBook.isDisposed()) {
                    InspectorViewer.this.reflow();
                }
                InspectorViewer.this.schedulingReflow = false;
            }
        });
        this.schedulingReflow = true;
    }

    protected void reflow() {
        if (this.contentForm != null && !this.contentForm.isDisposed()) {
            this.contentForm.reflow(true);
        }
    }

    private void showPage(int pageId) {
        if (this.pageBook == null || this.pageBook.isDisposed()) {
            return;
        }
        if (pageId == 1) {
            if (this.contentPage == null) {
                this.createContentPage((Composite)this.pageBook);
            }
            this.pageBook.showPage((Control)this.contentPage);
        } else if (pageId == 0) {
            this.pageBook.showPage((Control)this.emptyPage);
        }
    }

    private void createContentPage(Composite parent) {
        this.contentPage = this.factory.createComposite(parent, 524288);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.contentPage.setLayout((Layout)layout);
        this.contentForm = this.factory.createScrolledForm(this.contentPage);
        this.contentForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite contentBody = this.contentForm.getBody();
        final GridLayout contentLayout = new GridLayout(1, true);
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.verticalSpacing = 7;
        contentBody.setLayout((Layout)contentLayout);
        if (this.sections != null) {
            for (InspectorSection section : this.sections) {
                Composite composite = section.createSectionControl(contentBody, this.factory, this.contentForm);
                if (section.getControl() == null) continue;
                composite.setLayoutData((Object)new GridData(4, 4, true, false));
            }
        }
        this.contentForm.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int width = ((InspectorViewer)InspectorViewer.this).contentForm.getClientArea().width;
                width -= contentLayout.marginLeft + contentLayout.marginRight + contentLayout.marginWidth * 2;
                if (InspectorViewer.this.imageSection != null && !InspectorViewer.this.imageSection.getControl().isDisposed()) {
                    ((GridData)((InspectorViewer)InspectorViewer.this).imageSection.getControl().getLayoutData()).widthHint = width;
                }
                InspectorViewer.this.reflow();
            }
        });
    }

    public Control getControl() {
        return this.pageBook;
    }

    protected void handleDispose() {
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
        this.pageBook = null;
    }
}

