/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.resourcemanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.e4models.IContextRunnable;
import org.xmind.ui.internal.resourcemanager.ResourceManagerDialogPage;
import org.xmind.ui.internal.resourcemanager.ResourceManagerViewer;
import org.xmind.ui.internal.resourcemanager.StyleResourceManagerViewer;
import org.xmind.ui.internal.utils.ResourceUtils;
import org.xmind.ui.mindmap.MindMapUI;

public class StyleResourceManagerPage
extends ResourceManagerDialogPage
implements ICoreEventListener {
    private static final int editStyleButtonID = 1025;
    private CoreEventRegister coreEventRegister;
    private Button editStyleButton;
    private StyleResourceManagerViewer viewer;

    @Override
    protected ResourceManagerViewer createViewer() {
        this.viewer = new StyleResourceManagerViewer();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel;
                Object obj;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IStyle) {
                    StyleResourceManagerPage.this.editStyleButton.setEnabled(true);
                    return;
                }
                StyleResourceManagerPage.this.editStyleButton.setEnabled(false);
            }
        });
        this.registerCoreEvent();
        return this.viewer;
    }

    @Override
    protected void createButtonsForButtonBar(Composite buttonBar) {
        this.editStyleButton = this.createButton(buttonBar, 1025, MindMapMessages.StyleResourceManager_Editor_button, false);
        this.editStyleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyleResourceManagerViewer styleViewer = StyleResourceManagerPage.this.viewer;
                styleViewer.editStyle();
            }
        });
        this.editStyleButton.setEnabled(false);
    }

    private void registerCoreEvent() {
        ICoreEventSupport ces = (ICoreEventSupport)MindMapUI.getResourceManager().getUserStyleSheet().getAdapter(ICoreEventSupport.class);
        if (ces != null) {
            this.coreEventRegister = new CoreEventRegister((ICoreEventListener)this);
            this.coreEventRegister.setNextSupport(ces);
            this.coreEventRegister.register("styleAdd");
            this.coreEventRegister.register("styleRemove");
            this.coreEventRegister.register("titleText");
            this.coreEventRegister.register("name");
        }
    }

    public void handleCoreEvent(final CoreEvent event) {
        if (this.viewer == null) {
            return;
        }
        Control c = this.viewer.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                StyleResourceManagerPage.this.viewer.refresh();
                StyleResourceManagerPage.this.viewer.setSelection((ISelection)new StructuredSelection(event.getSource()), true);
            }
        });
    }

    @Override
    public void dispose() {
        if (this.coreEventRegister != null) {
            this.coreEventRegister.unregisterAll();
        }
        super.dispose();
    }

    @Override
    protected void registerRunnable(IEclipseContext eclipseContext) {
        super.registerRunnable(eclipseContext);
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.rename", (Object)new IContextRunnable(){

            public void run() {
                List styles;
                if (StyleResourceManagerPage.this.viewer != null && StyleResourceManagerPage.this.viewer.getControl() != null && !StyleResourceManagerPage.this.viewer.getControl().isDisposed() && (styles = StyleResourceManagerPage.this.getSelectedStyles()).size() == 1) {
                    StyleResourceManagerPage.this.viewer.startEditing((IStyle)styles.get(0));
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                return StyleResourceManagerPage.this.isOneUserStyleSelected();
            }
        });
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.duplicate", (Object)new IContextRunnable(){

            public void run() {
                List styles;
                if (StyleResourceManagerPage.this.viewer != null && StyleResourceManagerPage.this.viewer.getControl() != null && !StyleResourceManagerPage.this.viewer.getControl().isDisposed() && !(styles = StyleResourceManagerPage.this.getSelectedStyles()).isEmpty()) {
                    List<IStyle> newStyles = ResourceUtils.duplicateStyles(styles);
                    StyleResourceManagerPage.this.viewer.setSelection((ISelection)new StructuredSelection(newStyles));
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                List styles = StyleResourceManagerPage.this.getSelectedStyles();
                boolean canExecute = !styles.isEmpty();
                return canExecute;
            }
        });
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.delete", (Object)new IContextRunnable(){

            public void run() {
                List styles;
                if (StyleResourceManagerPage.this.viewer != null && StyleResourceManagerPage.this.viewer.getControl() != null && !StyleResourceManagerPage.this.viewer.getControl().isDisposed() && !(styles = StyleResourceManagerPage.this.getSelectedStyles()).isEmpty() && ResourceUtils.confirmToDeleteStyles(StyleResourceManagerPage.this.viewer.getControl().getShell(), styles)) {
                    ResourceUtils.deleteStyles(styles);
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                return StyleResourceManagerPage.this.isAllUserStyles();
            }
        });
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.edit", (Object)new IContextRunnable(){

            public void run() {
                StyleResourceManagerViewer styleViewer = StyleResourceManagerPage.this.viewer;
                styleViewer.editStyle();
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                List selected = StyleResourceManagerPage.this.getSelectedStyles();
                return selected != null && !selected.isEmpty();
            }
        });
    }

    private List<IStyle> getSelectedStyles() {
        IStructuredSelection selection;
        ArrayList<IStyle> styles = new ArrayList<IStyle>();
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed() && (selection = this.viewer.getStructuredSelection()) instanceof IStructuredSelection) {
            for (Object element : selection.toList()) {
                styles.add((IStyle)element);
            }
        }
        return styles;
    }

    @Override
    protected String getContextMenuId() {
        return "org.xmind.ui.dialogPart.resourceManager.style.popupMenu";
    }

    public String getModelPageId() {
        return "org.xmind.ui.dialogPart.resourceManager.style";
    }

    public String getModelPageTitle() {
        return null;
    }

    private boolean isAllUserStyles() {
        List<IStyle> styles = this.getSelectedStyles();
        Set userStyles = MindMapUI.getResourceManager().getUserStyleSheet().getAllStyles();
        boolean canExecute = !styles.isEmpty();
        for (IStyle style : styles) {
            boolean bl = canExecute = canExecute && userStyles.contains(style);
        }
        return canExecute;
    }

    private boolean isOneUserStyleSelected() {
        List<IStyle> styles = this.getSelectedStyles();
        IStyleSheet userStyleSheet = MindMapUI.getResourceManager().getUserStyleSheet();
        Set userStyles = userStyleSheet.getAllStyles();
        boolean canExecute = styles.size() == 1;
        for (IStyle style : styles) {
            boolean bl = canExecute = canExecute && userStyles.contains(style);
        }
        return canExecute;
    }
}

