/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.xmind.core.ITopic;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.Request;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.color.ColorPicker;
import org.xmind.ui.color.ColorSelection;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.decorations.IDecorationDescriptor;
import org.xmind.ui.internal.properties.LineWidth;
import org.xmind.ui.internal.properties.LineWidthLabelProvider;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.DecorationLabelProvider;
import org.xmind.ui.properties.StyledPropertySectionPart;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.viewers.MComboViewer;

public class TopicShapePropertySectionPart
extends StyledPropertySectionPart {
    private static List<IDecorationDescriptor> TopicShapes;
    private static List<IDecorationDescriptor> CalloutTopicShapes;
    private MComboViewer shapeViewer;
    private ColorPicker fillColorPicker;
    private ColorPicker borderLineColorPicker;
    private MComboViewer borderLineWidthViewer;

    @Override
    protected void createContent(Composite parent) {
        Composite line1 = new Composite(parent, 0);
        line1.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        line1.setLayout((Layout)layout);
        this.createShapeLineContent(line1);
        Composite line2 = new Composite(parent, 0);
        line2.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 3;
        layout2.verticalSpacing = 3;
        line2.setLayout((Layout)layout2);
        this.createBorderLineContent(line2);
    }

    private void createShapeLineContent(Composite parent) {
        this.shapeViewer = new MComboViewer(parent, 0);
        this.shapeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.shapeViewer.getControl().setToolTipText(PropertyMessages.TopicShape_toolTip);
        this.shapeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.shapeViewer.setLabelProvider((IBaseLabelProvider)new DecorationLabelProvider());
        this.shapeViewer.setInput(this.getShapes());
        this.shapeViewer.addSelectionChangedListener((ISelectionChangedListener)new ShapeSelectionChangedListener());
        this.fillColorPicker = new ColorPicker(7, PaletteContents.getDefault());
        this.fillColorPicker.getAction().setToolTipText(PropertyMessages.TopicFillColor_toolTip);
        this.fillColorPicker.addOpenListener((IOpenListener)new FillColorOpenListener());
        ToolBarManager colorBar = new ToolBarManager(0x800000);
        colorBar.add((IContributionItem)this.fillColorPicker);
        ToolBar barControl = colorBar.createControl(parent);
        barControl.setLayoutData((Object)new GridData(3, 2, false, false));
    }

    private void createBorderLineContent(Composite parent) {
        this.borderLineWidthViewer = new MComboViewer(parent, 0);
        this.borderLineWidthViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.borderLineWidthViewer.getControl().setToolTipText(PropertyMessages.LineWidth_toolTip);
        this.borderLineWidthViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.borderLineWidthViewer.setLabelProvider((IBaseLabelProvider)new LineWidthLabelProvider());
        this.borderLineWidthViewer.setInput((Object)LineWidth.values());
        this.borderLineWidthViewer.addSelectionChangedListener((ISelectionChangedListener)new BorderLineWidthSelectionChangedListener());
        this.borderLineColorPicker = new ColorPicker(5, PaletteContents.getDefault());
        this.borderLineColorPicker.getAction().setToolTipText(PropertyMessages.LineColor_toolTip);
        this.borderLineColorPicker.addOpenListener((IOpenListener)new BorderLineColorOpenListener());
        ToolBarManager colorBar = new ToolBarManager(0x800000);
        colorBar.add((IContributionItem)this.borderLineColorPicker);
        ToolBar barControl = colorBar.createControl(parent);
        barControl.setLayoutData((Object)new GridData(3, 2, false, false));
    }

    public void setFocus() {
        if (this.shapeViewer != null && !this.shapeViewer.getControl().isDisposed()) {
            this.shapeViewer.getControl().setFocus();
        } else if (this.borderLineWidthViewer != null && !this.borderLineWidthViewer.getControl().isDisposed()) {
            this.borderLineWidthViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.shapeViewer = null;
        this.fillColorPicker = null;
        this.borderLineWidthViewer = null;
        this.borderLineColorPicker = null;
    }

    @Override
    protected void doRefresh() {
        List<IDecorationDescriptor> newInput = this.getShapes();
        Object oldInput = this.shapeViewer.getInput();
        if (oldInput != newInput) {
            this.shapeViewer.setInput(newInput);
        }
        String shapeId = null;
        String shapeClassKey = "shape-class";
        if ("callout".equals(this.getCurrentTopicType())) {
            shapeClassKey = "callout-shape-class";
        }
        if (this.shapeViewer != null && !this.shapeViewer.getControl().isDisposed()) {
            IDecorationDescriptor element;
            shapeId = this.getStyleValue(shapeClassKey, null);
            if ("org.xmind.topicShape.noBorder".equals(shapeId)) {
                shapeId = "org.xmind.topicShape.rect";
            }
            if ((element = this.getSelectableShape(shapeId)) == null) {
                this.shapeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                this.shapeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
            ITopicPart topicPart = (ITopicPart)this.getGraphicalPart(this.getSelectedElements()[0]);
            if (topicPart != null) {
                IBranchPart part = topicPart.getOwnerBranch();
                String value = part.getBranchPolicy().getStyleSelector(topicPart).getOverridedValue((IGraphicalPart)part, "shape-class", "beforeUserValue");
                this.shapeViewer.getControl().setEnabled(value == null);
            }
        }
        if (this.fillColorPicker != null) {
            if (shapeId == null) {
                shapeId = this.getStyleValue(shapeClassKey, null);
            }
            this.updateColorPicker(this.fillColorPicker, "svg:fill", shapeId);
        }
        String lineShapeId = this.getLineShapeId();
        this.refreshWithShapeId(lineShapeId);
    }

    protected String getLineShapeId() {
        return this.getStyleValue("line-class", null);
    }

    protected void refreshWithShapeId(String lineShapeId) {
        if (this.borderLineWidthViewer != null && !this.borderLineWidthViewer.getControl().isDisposed()) {
            String borderLineWidth = this.getStyleValue("border-line-width", lineShapeId);
            LineWidth element = LineWidth.findByValue(borderLineWidth);
            if ("org.xmind.topicShape.noBorder".equals(this.getStyleValue("shape-class", null))) {
                element = LineWidth.None;
            }
            if (element == null) {
                element = LineWidth.findByValue(this.getStyleValue("line-width", lineShapeId));
            }
            if (element == null) {
                element = LineWidth.Thinnest;
            }
            this.borderLineWidthViewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
        if (this.borderLineColorPicker != null) {
            this.updateColorPicker(this.borderLineColorPicker, "border-line-color", lineShapeId);
        }
    }

    @Override
    protected void updateColorPicker(ColorPicker picker, String styleKey, String decorationId) {
        int type;
        String autoColor = this.getAutoValue(styleKey, decorationId);
        if (autoColor == null) {
            autoColor = this.getAutoValue(styleKey, decorationId);
        }
        picker.setAutoColor(StyleUtils.convertRGB(styleKey, autoColor));
        String userColor = this.getUserValue(styleKey);
        if (userColor == null) {
            userColor = this.getUserValue(styleKey);
        }
        if (userColor == null) {
            type = 1;
            userColor = autoColor;
        } else {
            type = 3;
        }
        if (type != 1 && "none".equals(userColor)) {
            type = 2;
        }
        RGB color = StyleUtils.convertRGB("fo:color", userColor);
        picker.setSelection((ISelection)new ColorSelection(type, color));
    }

    @Override
    protected void registerEventListener(Object source, ICoreEventRegister register) {
        super.registerEventListener(source, register);
        if (source instanceof ITopic) {
            register.register("structureClass");
        }
    }

    private IDecorationDescriptor getSelectableShape(String shapeId) {
        if (shapeId == null) {
            return null;
        }
        IDecorationDescriptor descriptor = MindMapUI.getDecorationManager().getDecorationDescriptor(shapeId);
        if (!this.getShapes().contains(descriptor)) {
            return null;
        }
        return descriptor;
    }

    private void changeShape(String newShape) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyTopicShape);
        boolean isCallout = "callout".equals(this.getCurrentTopicType());
        this.addStyle(request, isCallout ? "callout-shape-class" : "shape-class", newShape);
        this.sendRequest(request);
    }

    protected void changeFillColor(IColorSelection selection) {
        this.changeColor(selection, "svg:fill", CommandMessages.Command_ModifyFillColor);
    }

    private String getCurrentTopicType() {
        ISelection selection = this.getCurrentSelection();
        String wholeType = null;
        if (selection instanceof IStructuredSelection) {
            for (Object obj : ((IStructuredSelection)selection).toList()) {
                if (!(obj instanceof ITopic)) continue;
                String type = ((ITopic)obj).getType();
                if (type == null || wholeType != null && !wholeType.equals(type)) {
                    return null;
                }
                wholeType = type;
            }
        }
        return wholeType;
    }

    private List<IDecorationDescriptor> getShapes() {
        if ("callout".equals(this.getCurrentTopicType())) {
            return TopicShapePropertySectionPart.getCalloutTopicShapes();
        }
        return TopicShapePropertySectionPart.getTopicShapes();
    }

    private static List<IDecorationDescriptor> getTopicShapes() {
        if (TopicShapes == null) {
            TopicShapes = MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.topicDecorations");
        }
        return TopicShapes;
    }

    private static List<IDecorationDescriptor> getCalloutTopicShapes() {
        if (CalloutTopicShapes == null) {
            CalloutTopicShapes = MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.calloutTopicDecorations");
        }
        return CalloutTopicShapes;
    }

    protected void changeBorderLineColor(IColorSelection selection) {
        this.changeColor(selection, "border-line-color", CommandMessages.Command_ModifyBorderColor);
    }

    protected void changeBorderLineWidth(LineWidth lineWidth) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyBorderShape);
        String value = lineWidth == null ? null : lineWidth.getValue();
        this.addStyle(request, "border-line-width", value);
        this.sendRequest(request);
    }

    private class BorderLineColorOpenListener
    implements IOpenListener {
        private BorderLineColorOpenListener() {
        }

        public void open(OpenEvent event) {
            TopicShapePropertySectionPart.this.changeBorderLineColor((IColorSelection)event.getSelection());
        }
    }

    private class BorderLineWidthSelectionChangedListener
    implements ISelectionChangedListener {
        private BorderLineWidthSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (TopicShapePropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof LineWidth) {
                TopicShapePropertySectionPart.this.changeBorderLineWidth((LineWidth)((Object)o));
            }
        }
    }

    private class FillColorOpenListener
    implements IOpenListener {
        private FillColorOpenListener() {
        }

        public void open(OpenEvent event) {
            TopicShapePropertySectionPart.this.changeFillColor((IColorSelection)event.getSelection());
        }
    }

    private class ShapeSelectionChangedListener
    implements ISelectionChangedListener {
        private ShapeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (TopicShapePropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof IDecorationDescriptor) {
                TopicShapePropertySectionPart.this.changeShape(((IDecorationDescriptor)o).getId());
            }
        }
    }
}

