/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.xmind.ui.internal.ShareOption;
import org.xmind.ui.util.Logger;

public class ShareOptionRegistry {
    private List<ShareOption> options = null;

    ShareOptionRegistry() {
    }

    public List<ShareOption> getOptions() {
        this.ensureLoaded();
        return Collections.unmodifiableList(this.options);
    }

    public boolean hasOptions() {
        this.ensureLoaded();
        return !this.options.isEmpty();
    }

    public ShareOption getOptionById(String id) {
        Assert.isLegal((id != null ? 1 : 0) != 0);
        this.ensureLoaded();
        for (ShareOption option : this.options) {
            if (!id.equals(option.getId())) continue;
            return option;
        }
        return null;
    }

    public List<ShareOption> getOptionsByCategory(String category) {
        Assert.isLegal((category != null ? 1 : 0) != 0);
        this.ensureLoaded();
        ArrayList<ShareOption> result = new ArrayList<ShareOption>();
        for (ShareOption option : this.options) {
            if (!category.equals(option.getCategory())) continue;
            result.add(option);
        }
        return result;
    }

    private void ensureLoaded() {
        if (this.options != null) {
            return;
        }
        this.lazyLoad();
        if (this.options == null) {
            this.options = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.xmind.ui", "shareOptions");
        Assert.isNotNull((Object)extPoint);
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if ("option".equals(ele.getName())) {
                this.readShareOption(ele);
            }
            ++n2;
        }
    }

    private void readShareOption(IConfigurationElement element) {
        ShareOption descriptor;
        try {
            descriptor = new ShareOption(element);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load share item: " + element);
            return;
        }
        if (this.options == null) {
            this.options = new ArrayList<ShareOption>();
        }
        this.options.add(descriptor);
    }
}

