/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.ITopic;
import org.xmind.gef.ArraySourceProvider;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.command.SourceCommand;

public class AddTopicCommand
extends SourceCommand {
    private ISourceProvider parentProvider;
    private int index;
    private String type;

    public AddTopicCommand(ISourceProvider childProvider, ITopic parent) {
        this(childProvider, parent, -1, "attached");
    }

    public AddTopicCommand(ISourceProvider childProvider, ITopic parent, int index, String type) {
        super(childProvider);
        Assert.isNotNull((Object)parent);
        this.parentProvider = new ArraySourceProvider((Object)parent);
        this.index = index;
        this.type = type;
    }

    public AddTopicCommand(ITopic child, ITopic parent) {
        this(child, parent, -1, "attached");
    }

    public AddTopicCommand(ITopic child, ITopic parent, int index, String type) {
        super((Object)child);
        Assert.isNotNull((Object)parent);
        this.parentProvider = new ArraySourceProvider((Object)parent);
        this.index = index;
        this.type = type;
    }

    public AddTopicCommand(ISourceProvider childProvider, ISourceProvider parentProvider) {
        this(childProvider, parentProvider, -1, "attached");
    }

    public AddTopicCommand(ISourceProvider childProvider, ISourceProvider parentProvider, int index, String type) {
        super(childProvider);
        Assert.isNotNull((Object)parentProvider);
        Assert.isLegal((boolean)parentProvider.hasSource());
        this.parentProvider = parentProvider;
        this.index = index;
        this.type = type;
    }

    public AddTopicCommand(ITopic child, ISourceProvider parentProvider) {
        this(child, parentProvider, -1, "attached");
    }

    public AddTopicCommand(ITopic child, ISourceProvider parentProvider, int index, String type) {
        super((Object)child);
        Assert.isNotNull((Object)parentProvider);
        Assert.isLegal((boolean)parentProvider.hasSource());
        this.parentProvider = parentProvider;
        this.index = index;
        this.type = type;
    }

    public void redo() {
        int i = this.index;
        Object o = this.parentProvider.getSource();
        if (o instanceof ITopic) {
            ITopic parent = (ITopic)o;
            for (Object source : this.getSources()) {
                if (!(source instanceof ITopic)) continue;
                parent.add((ITopic)source, i, this.type);
                if (i < 0) continue;
                ++i;
            }
        }
        super.redo();
    }

    public void undo() {
        List sources = this.getSources();
        Object o = this.parentProvider.getSource();
        if (o instanceof ITopic) {
            ITopic parent = (ITopic)o;
            int i = sources.size() - 1;
            while (i >= 0) {
                Object source = sources.get(i);
                if (source instanceof ITopic) {
                    parent.remove((ITopic)source);
                }
                --i;
            }
        }
        super.undo();
    }
}

