/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml;

import java.util.Stack;
import java.util.StringTokenizer;
import jlibs.core.lang.StringUtil;

public class ClarkName {
    public static String valueOf(String namespace, String localPart) {
        return StringUtil.isEmpty((CharSequence)namespace) ? localPart : '{' + namespace + '}' + localPart;
    }

    public static String[] split(String clarkName) {
        int end = clarkName.lastIndexOf(125);
        if (end == -1) {
            return new String[]{"", clarkName};
        }
        return new String[]{clarkName.substring(1, end), clarkName.substring(end + 1)};
    }

    public static String[] splitPath(String clarkPath) {
        Stack<String> tokens = new Stack<String>();
        boolean foundNamespace = false;
        StringTokenizer stok = new StringTokenizer(clarkPath, "/", true);
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (foundNamespace) {
                token = (String)tokens.pop() + token;
            }
            if (token.charAt(0) == '{') {
                foundNamespace = true;
            }
            if (token.indexOf(125) != -1) {
                foundNamespace = false;
            }
            if (!foundNamespace && token.equals("/")) continue;
            tokens.push(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

