/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.filter;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.proxy.ProxyAuthException;
import org.apache.mina.proxy.ProxyLogicHandler;
import org.apache.mina.proxy.event.IoSessionEvent;
import org.apache.mina.proxy.event.IoSessionEventType;
import org.apache.mina.proxy.filter.ProxyHandshakeIoBuffer;
import org.apache.mina.proxy.handlers.ProxyRequest;
import org.apache.mina.proxy.handlers.http.HttpSmartProxyHandler;
import org.apache.mina.proxy.handlers.socks.Socks4LogicHandler;
import org.apache.mina.proxy.handlers.socks.Socks5LogicHandler;
import org.apache.mina.proxy.handlers.socks.SocksProxyRequest;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFilter
extends IoFilterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyFilter.class);

    public void onPreAdd(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) {
        if (ioFilterChain.contains(ProxyFilter.class)) {
            throw new IllegalStateException("A filter chain cannot contain more than one ProxyFilter.");
        }
    }

    public void onPreRemove(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) {
        IoSession ioSession = ioFilterChain.getSession();
        ioSession.removeAttribute(ProxyIoSession.PROXY_SESSION);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession ioSession, Throwable throwable) throws Exception {
        ProxyIoSession proxyIoSession = (ProxyIoSession)ioSession.getAttribute(ProxyIoSession.PROXY_SESSION);
        proxyIoSession.setAuthenticationFailed(true);
        super.exceptionCaught(nextFilter, ioSession, throwable);
    }

    private ProxyLogicHandler getProxyHandler(IoSession ioSession) {
        ProxyLogicHandler proxyLogicHandler = ((ProxyIoSession)ioSession.getAttribute(ProxyIoSession.PROXY_SESSION)).getHandler();
        if (proxyLogicHandler == null) {
            throw new IllegalStateException();
        }
        if (proxyLogicHandler.getProxyIoSession().getProxyFilter() != this) {
            throw new IllegalArgumentException("Not managed by this filter.");
        }
        return proxyLogicHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws ProxyAuthException {
        ProxyLogicHandler proxyLogicHandler;
        ProxyLogicHandler proxyLogicHandler2 = proxyLogicHandler = this.getProxyHandler(ioSession);
        synchronized (proxyLogicHandler2) {
            IoBuffer ioBuffer = (IoBuffer)object;
            if (proxyLogicHandler.isHandshakeComplete()) {
                nextFilter.messageReceived(ioSession, ioBuffer);
            } else {
                LOGGER.debug(" Data Read: {} ({})", (Object)proxyLogicHandler, (Object)ioBuffer);
                while (ioBuffer.hasRemaining() && !proxyLogicHandler.isHandshakeComplete()) {
                    LOGGER.debug(" Pre-handshake - passing to handler");
                    int n = ioBuffer.position();
                    proxyLogicHandler.messageReceived(nextFilter, ioBuffer);
                    if (ioBuffer.position() != n && !ioSession.isClosing()) continue;
                    return;
                }
                if (ioBuffer.hasRemaining()) {
                    LOGGER.debug(" Passing remaining data to next filter");
                    nextFilter.messageReceived(ioSession, ioBuffer);
                }
            }
        }
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, WriteRequest writeRequest) {
        this.writeData(nextFilter, ioSession, writeRequest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(IoFilter.NextFilter nextFilter, IoSession ioSession, WriteRequest writeRequest, boolean bl) {
        ProxyLogicHandler proxyLogicHandler;
        ProxyLogicHandler proxyLogicHandler2 = proxyLogicHandler = this.getProxyHandler(ioSession);
        synchronized (proxyLogicHandler2) {
            if (proxyLogicHandler.isHandshakeComplete()) {
                nextFilter.filterWrite(ioSession, writeRequest);
            } else if (bl) {
                LOGGER.debug("   handshake data: {}", writeRequest.getMessage());
                nextFilter.filterWrite(ioSession, writeRequest);
            } else if (!ioSession.isConnected()) {
                LOGGER.debug(" Write request on closed session. Request ignored.");
            } else {
                LOGGER.debug(" Handshaking is not complete yet. Buffering write request.");
                proxyLogicHandler.enqueueWriteRequest(nextFilter, writeRequest);
            }
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, WriteRequest writeRequest) throws Exception {
        if (writeRequest.getMessage() != null && writeRequest.getMessage() instanceof ProxyHandshakeIoBuffer) {
            return;
        }
        nextFilter.messageSent(ioSession, writeRequest);
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        LOGGER.debug("Session created: " + ioSession);
        ProxyIoSession proxyIoSession = (ProxyIoSession)ioSession.getAttribute(ProxyIoSession.PROXY_SESSION);
        LOGGER.debug("  get proxyIoSession: " + proxyIoSession);
        proxyIoSession.setProxyFilter(this);
        ProxyLogicHandler proxyLogicHandler = proxyIoSession.getHandler();
        if (proxyLogicHandler == null) {
            SocksProxyRequest socksProxyRequest;
            ProxyRequest proxyRequest = proxyIoSession.getRequest();
            proxyLogicHandler = proxyRequest instanceof SocksProxyRequest ? ((socksProxyRequest = (SocksProxyRequest)proxyRequest).getProtocolVersion() == 4 ? new Socks4LogicHandler(proxyIoSession) : new Socks5LogicHandler(proxyIoSession)) : new HttpSmartProxyHandler(proxyIoSession);
            proxyIoSession.setHandler(proxyLogicHandler);
            proxyLogicHandler.doHandshake(nextFilter);
        }
        proxyIoSession.getEventQueue().enqueueEventIfNecessary(new IoSessionEvent(nextFilter, ioSession, IoSessionEventType.CREATED));
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        ProxyIoSession proxyIoSession = (ProxyIoSession)ioSession.getAttribute(ProxyIoSession.PROXY_SESSION);
        proxyIoSession.getEventQueue().enqueueEventIfNecessary(new IoSessionEvent(nextFilter, ioSession, IoSessionEventType.OPENED));
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession ioSession, IdleStatus idleStatus) throws Exception {
        ProxyIoSession proxyIoSession = (ProxyIoSession)ioSession.getAttribute(ProxyIoSession.PROXY_SESSION);
        proxyIoSession.getEventQueue().enqueueEventIfNecessary(new IoSessionEvent(nextFilter, ioSession, idleStatus));
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        ProxyIoSession proxyIoSession = (ProxyIoSession)ioSession.getAttribute(ProxyIoSession.PROXY_SESSION);
        proxyIoSession.getEventQueue().enqueueEventIfNecessary(new IoSessionEvent(nextFilter, ioSession, IoSessionEventType.CLOSED));
    }
}

