/*
 * Decompiled with CFR 0.152.
 */
package app.util;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.Hashtable;

public class FileDialogger
extends FileDialog {
    public static final int LOAD_DIR = 10;
    public static final int LOAD_APP = 11;
    private static final String[] NO_PROPS = new String[0];
    private final String[] propNames;

    public static FileDialog makeFileDialog(Frame frame, String string, int n) {
        String[] stringArray = NO_PROPS;
        if (n == 10 || n == 3) {
            n = 0;
            if (System.getProperty("os.name", "").startsWith("Mac OS")) {
                stringArray = new String[]{"apple.awt.fileDialogForDirectories"};
                String string2 = System.getProperty("java.version", "");
                if (string2.startsWith("1.1") || string2.startsWith("1.3")) {
                    n = 3;
                }
            }
        }
        if (n == 11) {
            n = 0;
            if (System.getProperty("os.name", "").startsWith("Mac OS")) {
                stringArray = new String[2];
                stringArray[0] = "apple.awt.use-file-dialog-packages";
                if (System.getProperty("java.version", "").startsWith("1.3")) {
                    stringArray[0] = "com.apple.macos.use-file-dialog-packages";
                }
            }
        }
        return new FileDialogger(frame, string, n, stringArray);
    }

    public static File runFileDialog(Frame frame, String string, int n) {
        return FileDialogger.runFileDialog(FileDialogger.makeFileDialog(frame, string, n));
    }

    public static File runFileDialog(FileDialog fileDialog) {
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null || string2 == null) {
            return null;
        }
        return new File(string2, string);
    }

    private FileDialogger(Frame frame, String string, int n, String[] stringArray) {
        super(frame, string, n);
        this.propNames = stringArray;
    }

    public void show() {
        String[] stringArray = this.propNames;
        if (stringArray == null) {
            stringArray = NO_PROPS;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                stringArray2[n] = System.getProperty(string);
                ((Hashtable)System.getProperties()).put(string, "true");
            }
            ++n;
        }
        super.show();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            if (string != null) {
                String string2 = stringArray2[n2];
                if (string2 == null) {
                    ((Hashtable)System.getProperties()).remove(string);
                } else {
                    ((Hashtable)System.getProperties()).put(string, string2);
                }
            }
            ++n2;
        }
    }
}

