/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

final class GenericChunk
extends IFFChunk {
    byte[] data;

    protected GenericChunk(int n, int n2) {
        super(n, n2);
        this.data = new byte[n2 <= 50 ? n2 : 47];
    }

    protected GenericChunk(int n, byte[] byArray) {
        super(n, byArray.length);
        this.data = byArray;
    }

    @Override
    void readChunk(DataInput dataInput) throws IOException {
        dataInput.readFully(this.data, 0, this.data.length);
        GenericChunk.skipData(dataInput, this.chunkLength, this.data.length);
    }

    @Override
    void writeChunk(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.chunkId);
        dataOutput.writeInt(this.chunkLength);
        dataOutput.write(this.data, 0, this.data.length);
        if (this.data.length % 2 != 0) {
            dataOutput.writeByte(0);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " {value=\"" + new String(this.data, 0, this.data.length <= 50 ? this.data.length : 47) + (this.chunkLength <= 50 ? "" : "...") + "\"}";
    }
}

