/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Shortcut;

public class JumpToAction
extends JosmAction {
    private final JosmTextField url = new JosmTextField();
    private final JosmTextField lat = new JosmTextField();
    private final JosmTextField lon = new JosmTextField();
    private final JosmTextField zm = new JosmTextField();

    public JumpToAction() {
        super(I18n.tr("Jump To Position", new Object[0]), (ImageProvider)null, I18n.tr("Opens a dialog that allows to jump to a specific location", new Object[0]), Shortcut.registerShortcut("tools:jumpto", I18n.tr("Tool: {0}", I18n.tr("Jump To Position", new Object[0])), 74, 5006), true, "action/jumpto", true);
        this.putValue("help", HelpUtil.ht("/Action/JumpToPosition"));
    }

    public void showJumpToDialog() {
        if (!Main.isDisplayingMapView()) {
            return;
        }
        MapView mapView = Main.map.mapView;
        Optional<Bounds> optional = Optional.ofNullable(ClipboardUtils.getClipboardStringContent()).map(OsmUrlToBounds::parse);
        if (optional.isPresent()) {
            this.setBounds(optional.get());
        } else {
            this.setBounds(mapView.getState().getViewArea().getCornerBounds());
        }
        this.updateUrl(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("<html>" + I18n.tr("Enter Lat/Lon to jump to position.", new Object[0]) + "<br>" + I18n.tr("You can also paste an URL from www.openstreetmap.org", new Object[0]) + "<br></html>"), "North");
        OsmLonLatListener osmLonLatListener = new OsmLonLatListener();
        this.lat.getDocument().addDocumentListener(osmLonLatListener);
        this.lon.getDocument().addDocumentListener(osmLonLatListener);
        this.zm.getDocument().addDocumentListener(osmLonLatListener);
        this.url.getDocument().addDocumentListener(new OsmURLListener());
        SelectAllOnFocusGainedDecorator.decorate(this.lat);
        SelectAllOnFocusGainedDecorator.decorate(this.lon);
        SelectAllOnFocusGainedDecorator.decorate(this.zm);
        SelectAllOnFocusGainedDecorator.decorate(this.url);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)new JLabel(I18n.tr("Latitude", new Object[0])), GBC.eol());
        jPanel2.add((Component)this.lat, GBC.eol().fill(2));
        jPanel2.add((Component)new JLabel(I18n.tr("Longitude", new Object[0])), GBC.eol());
        jPanel2.add((Component)this.lon, GBC.eol().fill(2));
        jPanel2.add((Component)new JLabel(I18n.tr("Zoom (in metres)", new Object[0])), GBC.eol());
        jPanel2.add((Component)this.zm, GBC.eol().fill(2));
        jPanel2.add((Component)new JLabel(I18n.tr("URL", new Object[0])), GBC.eol());
        jPanel2.add((Component)this.url, GBC.eol().fill(2));
        String[] stringArray = new String[]{I18n.tr("Jump there", new Object[0]), I18n.tr("Cancel", new Object[0])};
        LatLon latLon = null;
        double d = 100.0;
        while (latLon == null) {
            int n = new JumpToPositionDialog(stringArray, jPanel).showDialog().getValue();
            if (n != 1) {
                return;
            }
            try {
                d = Double.parseDouble(this.zm.getText());
                latLon = new LatLon(Double.parseDouble(this.lat.getText()), Double.parseDouble(this.lon.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    latLon = LatLon.parse(this.lat.getText() + "; " + this.lon.getText());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not parse Latitude, Longitude or Zoom. Please check.", new Object[0]), I18n.tr("Unable to parse Lon/Lat", new Object[0]), 0);
                }
            }
        }
        double d2 = 1.0 / mapView.getDist100Pixel();
        mapView.zoomToFactor(mapView.getProjection().latlon2eastNorth(latLon), d2 * d);
    }

    private void parseURL() {
        if (!this.url.hasFocus()) {
            return;
        }
        String string = this.url.getText();
        Bounds bounds = OsmUrlToBounds.parse(string);
        this.setBounds(bounds);
    }

    private void setBounds(Bounds bounds) {
        if (bounds != null) {
            LatLon latLon = bounds.getCenter();
            this.lat.setText(Double.toString(latLon.lat()));
            this.lon.setText(Double.toString(latLon.lon()));
            this.zm.setText(Double.toString(OsmUrlToBounds.getZoom(bounds)));
        }
    }

    private void updateUrl(boolean bl) {
        if (!(this.lat.hasFocus() || this.lon.hasFocus() || this.zm.hasFocus() || bl)) {
            return;
        }
        try {
            double d = Double.parseDouble(this.lat.getText());
            double d2 = Double.parseDouble(this.lon.getText());
            double d3 = Double.parseDouble(this.zm.getText());
            this.url.setText(OsmUrlToBounds.getURL(d, d2, (int)d3));
        }
        catch (NumberFormatException numberFormatException) {
            Main.debug(numberFormatException.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.showJumpToDialog();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(Main.isDisplayingMapView());
    }

    @Override
    protected void installAdapters() {
        super.installAdapters();
        Main.addMapFrameListener((mapFrame, mapFrame2) -> this.updateEnabledState());
    }

    class OsmLonLatListener
    implements DocumentListener {
        OsmLonLatListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JumpToAction.this.updateUrl(false);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JumpToAction.this.updateUrl(false);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JumpToAction.this.updateUrl(false);
        }
    }

    class OsmURLListener
    implements DocumentListener {
        OsmURLListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JumpToAction.this.parseURL();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JumpToAction.this.parseURL();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JumpToAction.this.parseURL();
        }
    }

    static class JumpToPositionDialog
    extends ExtendedDialog {
        JumpToPositionDialog(String[] stringArray, JPanel jPanel) {
            super(Main.parent, I18n.tr("Jump to Position", new Object[0]), stringArray);
            this.setContent(jPanel);
            this.setCancelButton(2);
        }
    }
}

