/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp.compiler;

import java.util.ArrayList;
import java.util.List;
import org.grails.gsp.compiler.GroovyPageExpressionParser;
import org.grails.gsp.compiler.Strip;
import org.grails.gsp.compiler.Tokens;
import org.grails.taglib.GrailsTagException;

class GroovyPageScanner
implements Tokens {
    private static final int DEFAULT_MAX_HTML_LENGTH = 64000;
    private String text;
    private int end1;
    private int begin1;
    private int end2;
    private int begin2;
    private int state = 0;
    private int len;
    private String lastNamespace;
    private List<Integer> lineNumberPositions;
    private int lastLineNumberIndex = -1;
    private String pageName = "Unknown";
    private int maxHtmlLength = 64000;

    GroovyPageScanner(String text) {
        Strip strip = new Strip(text);
        strip.strip(0);
        this.text = strip.toString();
        this.len = this.text.length();
        this.resolveLineNumberPositions();
    }

    public GroovyPageScanner(String gspSource, String uri) {
        this(gspSource);
        this.pageName = uri;
    }

    private void resolveLineNumberPositions() {
        this.lineNumberPositions = new ArrayList<Integer>();
        this.lineNumberPositions.add(0);
        for (int i = 0; i < this.len; ++i) {
            if (this.text.charAt(i) != '\n') continue;
            this.lineNumberPositions.add(i + 1);
        }
    }

    private int found(int newState, int skip) {
        this.begin2 = this.begin1;
        this.end2 = --this.end1;
        this.begin1 = this.end1 += skip;
        int lastState = this.state;
        this.state = newState;
        return lastState;
    }

    private int foundStartOrEndTag(int newState, int skip, String namespace) {
        this.begin2 = this.begin1;
        this.end2 = --this.end1;
        this.begin1 = this.end1 += skip;
        int lastState = this.state;
        this.state = newState;
        this.lastNamespace = namespace;
        return lastState;
    }

    String getToken() {
        return this.text.substring(this.begin2, this.end2);
    }

    int getLineNumberForToken() {
        for (int i = this.lastLineNumberIndex + 1; i < this.lineNumberPositions.size(); ++i) {
            if (this.lineNumberPositions.get(i) <= this.begin2) continue;
            this.lastLineNumberIndex = i - 1;
            return i;
        }
        return 1;
    }

    String getNamespace() {
        return this.lastNamespace;
    }

    int nextToken() {
        while (true) {
            int left;
            if ((left = this.len - this.end1) == 0) {
                ++this.end1;
                return this.found(-1, 0);
            }
            char c = this.text.charAt(this.end1++);
            char c1 = left > 1 ? this.text.charAt(this.end1) : (char)'\u0000';
            char c2 = left > 2 ? this.text.charAt(this.end1 + 1) : (char)'\u0000';
            int tokenLength = this.end1 - this.begin1;
            switch (this.state) {
                case 0: {
                    if (this.isPotentialScriptletOrTag(c, left)) {
                        if (c1 == '%') {
                            if (c2 == '=') {
                                return this.found(1, 3);
                            }
                            if (c2 == '@') {
                                return this.found(3, 3);
                            }
                            if (c2 == '!') {
                                return this.found(4, 3);
                            }
                            if (this.isStartComment(c1, c2, left) && this.skipJComment()) break;
                            return this.found(2, 2);
                        }
                        boolean bStartTag = !this.isClosingTag(c1);
                        String tagNameSpace = this.getTagNamespace(bStartTag ? this.end1 : this.end1 + 1);
                        if (this.isTagDefinition(tagNameSpace)) {
                            if (bStartTag) {
                                return this.foundStartOrEndTag(15, tagNameSpace.length() + 2, tagNameSpace);
                            }
                            return this.foundStartOrEndTag(16, tagNameSpace.length() + 3, tagNameSpace);
                        }
                    } else if (this.isStartOfGExpression(c, c1)) {
                        return this.found(11, 2);
                    }
                    if (c == '%' && c1 == '{') {
                        if (c2 == '-' && left > 3 && this.text.charAt(this.end1 + 2) == '-' && this.skipGComment()) break;
                        return this.found(12, 2);
                    }
                    if (c == '!' && c1 == '{') {
                        return this.found(14, 2);
                    }
                    if (c == '@' && c1 == '{') {
                        return this.found(13, 2);
                    }
                    if (tokenLength <= this.maxHtmlLength) break;
                    return this.found(0, 0);
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (c != '%' || c1 != '>') break;
                    return this.found(0, 2);
                }
                case 15: {
                    if (this.isStartOfGExpression(c, c1)) {
                        return this.found(17, 2);
                    }
                    if (c == '>') {
                        return this.found(0, 1);
                    }
                    if (!this.isClosingTag(c) || c1 != '>') break;
                    return this.found(18, 1);
                }
                case 16: 
                case 18: {
                    if (c != '>') break;
                    return this.found(0, 1);
                }
                case 11: 
                case 17: {
                    return this.parseExpression();
                }
                case 13: {
                    if (c != '}') break;
                    return this.found(0, 1);
                }
                case 12: {
                    if (c != '}' || c1 != '%') break;
                    return this.found(0, 2);
                }
                case 14: {
                    if (c != '}' || c1 != '!' && c1 != '%') break;
                    return this.found(0, 2);
                }
            }
        }
    }

    protected int parseExpression() {
        char terminationChar = '}';
        char nextTerminationChar = '\u0000';
        boolean startInExpression = true;
        GroovyPageExpressionParser expressionParser = new GroovyPageExpressionParser(this.text, this.end1 - 1, terminationChar, nextTerminationChar, startInExpression);
        int endpos = expressionParser.parse();
        if (endpos != -1) {
            this.end1 = endpos + 1;
            int expressionEndState = 0;
            if (this.state == 17) {
                expressionEndState = 15;
            }
            return this.found(expressionEndState, nextTerminationChar == '\u0000' ? 1 : 2);
        }
        throw new GrailsTagException("Unclosed GSP expression", this.pageName, this.getLineNumberForToken());
    }

    private boolean isClosingTag(char c1) {
        return c1 == '/';
    }

    private boolean isTagDefinition(String tagNameSpace) {
        return tagNameSpace != null && tagNameSpace.matches("^\\p{Alpha}\\w*$");
    }

    private String getTagNamespace(int fromIndex) {
        int foundColonIdx = this.text.indexOf(":", fromIndex);
        String tagNameSpace = null;
        if (foundColonIdx > -1) {
            tagNameSpace = this.text.substring(fromIndex, foundColonIdx);
        }
        return tagNameSpace;
    }

    private boolean isPotentialScriptletOrTag(char c, int left) {
        return c == '<' && left > 3;
    }

    private boolean isStartComment(char c1, char c2, int left) {
        return c1 == '%' && c2 == '-' && left > 3 && this.text.charAt(this.end1 + 2) == '-';
    }

    private boolean isStartOfGExpression(char c, char c1) {
        return c == '$' && c1 == '{';
    }

    private boolean skipComment(char c3, char c4) {
        int ix = this.end1 + 3;
        int ixz = this.len - 4;
        while (true) {
            if (ix > ixz) {
                return false;
            }
            if (this.text.charAt(ix) == '-' && this.text.charAt(ix + 1) == '-' && this.text.charAt(ix + 2) == c3 && this.text.charAt(ix + 3) == c4) break;
            ++ix;
        }
        this.text = this.text.substring(0, --this.end1) + this.text.substring(ix + 4);
        this.len = this.text.length();
        return true;
    }

    private boolean skipGComment() {
        return this.skipComment('}', '%');
    }

    private boolean skipJComment() {
        return this.skipComment('%', '>');
    }

    void reset() {
        this.begin2 = 0;
        this.end2 = 0;
        this.begin1 = 0;
        this.end1 = 0;
        this.state = 0;
        this.lastNamespace = null;
        this.lastLineNumberIndex = -1;
    }

    public int getMaxHtmlLength() {
        return this.maxHtmlLength;
    }

    public void setMaxHtmlLength(int maxHtmlLength) {
        this.maxHtmlLength = maxHtmlLength;
    }
}

