/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.helper;

import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.jama.Matrix;

public class AlignTools {
    public static Atom[] getFragmentFromIdxList(Atom[] caall, int[] idx) {
        Atom[] subset = new Atom[idx.length];
        for (int p = 0; p < idx.length; ++p) {
            int pos1 = idx[p];
            subset[p] = (Atom)caall[pos1].clone();
        }
        return subset;
    }

    public static Atom[] getFragment(Atom[] caall, int pos, int fragmentLength) {
        if (pos + fragmentLength > caall.length) {
            return null;
        }
        Atom[] tmp = new Atom[fragmentLength];
        for (int i = 0; i < fragmentLength; ++i) {
            tmp[i] = (Atom)caall[i + pos].clone();
        }
        return tmp;
    }

    public static Atom[] getFragmentNoClone(Atom[] caall, int pos, int fragmentLength) {
        if (pos + fragmentLength > caall.length) {
            return null;
        }
        Atom[] tmp = new Atom[fragmentLength];
        for (int i = 0; i < fragmentLength; ++i) {
            tmp[i] = caall[i + pos];
        }
        return tmp;
    }

    public static Atom getCenter(Atom[] ca, int pos, int fragmentLength) {
        AtomImpl center = new AtomImpl();
        if (pos + fragmentLength > ca.length) {
            System.err.println("pos (" + pos + "), fragL (" + fragmentLength + ") > ca.length" + ca.length);
            return center;
        }
        Atom[] tmp = AlignTools.getFragmentNoClone(ca, pos, fragmentLength);
        return Calc.getCentroid(tmp);
    }

    public static double[] getDiagonalAtK(Atom[] atoms, int k) {
        int l = atoms.length;
        double[] dk = new double[l - k];
        for (int i = 0; i < l - k; ++i) {
            try {
                double dist;
                dk[i] = dist = Calc.getDistance(atoms[i], atoms[i + k]);
                continue;
            }
            catch (StructureException e) {
                // empty catch block
            }
        }
        return dk;
    }

    public static double rms_dk_diag(double[] dk1, double[] dk2, int i, int j, int l, int k) {
        double dk = 0.0;
        for (int x2 = 0; x2 < l - k; ++x2) {
            dk += (dk1[x2 + i] - dk2[x2 + j]) * (dk1[x2 + i] - dk2[x2 + j]);
        }
        return Math.sqrt(dk /= (double)(l - k));
    }

    public static Matrix getDistanceMatrix(Atom[] ca1, Atom[] ca2) {
        int r = ca1.length;
        int c = ca2.length;
        Matrix out = new Matrix(r, c);
        for (int i = 0; i < r; ++i) {
            Atom a1 = ca1[i];
            for (int j = 0; j < c; ++j) {
                Atom b1 = ca2[j];
                try {
                    double d = Calc.getDistance(a1, b1);
                    out.set(i, j, d);
                    continue;
                }
                catch (StructureException e) {
                    e.printStackTrace();
                    out.set(i, j, 999.0);
                }
            }
        }
        return out;
    }
}

