/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleBaseMath;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class DoubleShortConvolutionStrategy
extends DoubleBaseMath
implements ConvolutionStrategy {
    private static final long serialVersionUID = -2048097533911386543L;

    public DoubleShortConvolutionStrategy(int radix) {
        super(radix);
    }

    public DataStorage convolute(DataStorage x2, DataStorage y, long resultSize) throws ApfloatRuntimeException {
        DataStorage longStorage;
        DataStorage shortStorage;
        if (x2.getSize() > 1L) {
            shortStorage = y;
            longStorage = x2;
        } else {
            shortStorage = x2;
            longStorage = y;
        }
        assert (shortStorage.getSize() == 1L);
        long size2 = longStorage.getSize() + 1L;
        ArrayAccess arrayAccess = shortStorage.getArray(1, 0L, 1);
        double factor = arrayAccess.getDoubleData()[arrayAccess.getOffset()];
        arrayAccess.close();
        ApfloatContext ctx = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = ctx.getBuilderFactory().getDataStorageBuilder();
        DataStorage resultStorage = dataStorageBuilder.createDataStorage(size2 * 8L);
        resultStorage.setSize(size2);
        DataStorage.Iterator src = longStorage.iterator(1, size2 - 1L, 0L);
        DataStorage.Iterator dst = resultStorage.iterator(2, size2, 0L);
        double carry = this.baseMultiplyAdd(src, null, factor, 0.0, dst, size2 - 1L);
        dst.setDouble(carry);
        dst.close();
        return resultStorage;
    }
}

