/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.testCases;

import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.SnpSift;
import org.snpsift.SnpSiftCmdCaseControl;

public class TestCasesCaseControl
extends TestCase {
    public static boolean verbose = false;
    public static boolean debug = false;

    void checkCaseControlString(String vcfFile, String geoupStr, String casesStr, String controlStr) {
        String[] args = new String[]{"caseControl", geoupStr, vcfFile};
        SnpSift snpSift = new SnpSift(args);
        SnpSiftCmdCaseControl cmd = (SnpSiftCmdCaseControl)snpSift.cmd();
        List<VcfEntry> vcfEntries = cmd.run(true);
        for (VcfEntry ve : vcfEntries) {
            if (verbose) {
                System.out.println(ve);
            }
            Assert.assertEquals(casesStr, ve.getInfo("Cases"));
            Assert.assertEquals(controlStr, ve.getInfo("Controls"));
        }
    }

    void checkCaseControlTfam(String vcfFile, String tfamFile, String casesStr, String controlStr) {
        String[] args = new String[]{"caseControl", "-tfam", tfamFile, vcfFile};
        SnpSift snpSift = new SnpSift(args);
        SnpSiftCmdCaseControl cmd = (SnpSiftCmdCaseControl)snpSift.cmd();
        List<VcfEntry> vcfEntries = cmd.run(true);
        for (VcfEntry ve : vcfEntries) {
            if (verbose) {
                System.out.println(ve);
            }
            Assert.assertEquals(casesStr, ve.getInfo("Cases"));
            Assert.assertEquals(controlStr, ve.getInfo("Controls"));
        }
    }

    public void test_01() {
        Gpr.debug("Test");
        this.checkCaseControlTfam("test/test.private.01.vcf", "test/test.private.01.tfam", "0,0,0", "0,0,0");
    }

    public void test_01_Str() {
        Gpr.debug("Test");
        this.checkCaseControlString("test/test.private.01.vcf", "--", "0,0,0", "0,0,0");
    }

    public void test_02() {
        Gpr.debug("Test");
        this.checkCaseControlTfam("test/test.private.02.vcf", "test/test.private.01.tfam", "0,0,0", "2,0,4");
    }

    public void test_02_Str() {
        Gpr.debug("Test");
        this.checkCaseControlString("test/test.private.02.vcf", "--", "0,0,0", "2,0,4");
    }

    public void test_02_Str2() {
        Gpr.debug("Test");
        this.checkCaseControlString("test/test.private.02.vcf", "-+", "1,0,2", "1,0,2");
    }

    public void test_03() {
        Gpr.debug("Test");
        this.checkCaseControlTfam("test/test.private.03.vcf", "test/test.private.01.tfam", "0,0,0", "0,1,1");
    }

    public void test_03_Str() {
        Gpr.debug("Test");
        this.checkCaseControlString("test/test.private.03.vcf", "--", "0,0,0", "0,1,1");
    }

    public void test_03_Str2() {
        Gpr.debug("Test");
        this.checkCaseControlString("test/test.private.03.vcf", "+-", "0,1,1", "0,0,0");
    }

    public void test_03_Str3() {
        Gpr.debug("Test");
        this.checkCaseControlString("test/test.private.03.vcf", "0+", "0,0,0", "0,0,0");
    }

    public void test_04() {
        Gpr.debug("Test");
        this.checkCaseControlTfam("test/test.private.04.vcf", "test/test.private.01.tfam", "0,0,0", "1,0,2");
    }

    public void test_04_Str() {
        Gpr.debug("Test");
        this.checkCaseControlString("test/test.private.04.vcf", "--", "0,0,0", "1,0,2");
    }

    public void test_05() {
        Gpr.debug("Test");
        this.checkCaseControlTfam("test/test.private.05.vcf", "test/test.private.05.tfam", "0,0,0", "0,0,0");
    }

    public void test_06() {
        Gpr.debug("Test");
        this.checkCaseControlTfam("test/test.private.06.vcf", "test/test.private.05.tfam", "0,1,1", "0,0,0");
    }

    public void test_07() {
        Gpr.debug("Test");
        this.checkCaseControlTfam("test/test.private.07.vcf", "test/test.private.05.tfam", "0,1,1", "0,1,1");
    }

    public void test_08() {
        Gpr.debug("Test");
        this.checkCaseControlTfam("test/test.private.08.vcf", "test/test.private.05.tfam", "0,2,2", "0,1,1");
    }

    public void test_09() {
        Gpr.debug("Test");
        String vcfFile = "test/caseContorlStudies.vcf";
        String tfamFile = "test/caseContorlStudies.tfam";
        double maxDiff = 0.01;
        String[] args = new String[]{"caseControl", "-chi2", "-tfam", tfamFile, vcfFile};
        SnpSift snpSift = new SnpSift(args);
        SnpSiftCmdCaseControl cmd = (SnpSiftCmdCaseControl)snpSift.cmd();
        List<VcfEntry> vcfEntries = cmd.run(true);
        for (VcfEntry ve : vcfEntries) {
            double ratio;
            if (verbose) {
                System.out.println(ve.toStringNoGt());
            }
            double pDom = ve.getInfoFloat("P_DOM");
            double pAllelic = ve.getInfoFloat("P_ALLELIC");
            double pRec = ve.getInfoFloat("P_REC");
            double pTrend = ve.getInfoFloat("P_TREND");
            double pGeno = ve.getInfoFloat("P_GENO");
            double pDomCc = ve.getInfoFloat("CC_DOM");
            double pAllelicCc = ve.getInfoFloat("CC_ALL");
            double pRecCc = ve.getInfoFloat("CC_REC");
            double pTrendCc = ve.getInfoFloat("CC_TREND");
            double pGenoCc = ve.getInfoFloat("CC_GENO");
            if (pAllelic > 0.0) {
                ratio = pAllelic / pAllelicCc;
                if (verbose) {
                    System.out.println("\tAllelic \tRatio: " + ratio + "\tPLINK: " + pAllelic + "\tCalculated: " + pAllelicCc + "\t");
                }
                Assert.assertEquals(1.0, ratio, maxDiff);
            }
            if (pDom > 0.0) {
                ratio = pDom / pDomCc;
                if (verbose) {
                    System.out.println("\tDominant\tRatio: " + ratio + "\tPLINK: " + pDom + "\tCalculated: " + pDomCc + "\t");
                }
                Assert.assertEquals(1.0, ratio, maxDiff);
            }
            if (pRec > 0.0) {
                ratio = pRec / pRecCc;
                if (verbose) {
                    System.out.println("\tRecessive\tRatio: " + ratio + "\tPLINK: " + pRec + "\tCalculated: " + pRecCc + "\t");
                }
                Assert.assertEquals(1.0, ratio, maxDiff);
            }
            if (pTrend > 0.0) {
                ratio = pTrend / pTrendCc;
                if (verbose) {
                    System.out.println("\tTrend    \tRatio: " + ratio + "\tPLINK: " + pTrend + "\tCalculated: " + pTrendCc + "\t");
                }
                Assert.assertEquals(1.0, ratio, maxDiff);
            }
            if (pGeno > 0.0) {
                ratio = pGeno / pGenoCc;
                if (verbose) {
                    System.out.println("\tGenotypic\tRatio: " + ratio + "\tPLINK: " + pGeno + "\tCalculated: " + pGenoCc + "\t");
                }
                Assert.assertEquals(1.0, ratio, maxDiff);
            }
            if (!verbose) continue;
            System.out.println("");
        }
    }

    public void test_10() {
        Gpr.debug("Test");
        String vcfFile = "test/caseContorlStudies.vcf";
        String tfamFile = "test/caseContorlStudies.tfam";
        String[] args = new String[]{"caseControl", "-tfam", tfamFile, vcfFile};
        SnpSift snpSift = new SnpSift(args);
        SnpSiftCmdCaseControl cmd = (SnpSiftCmdCaseControl)snpSift.cmd();
        List<VcfEntry> vcfEntries = cmd.run(true);
        for (VcfEntry ve : vcfEntries) {
            double ratio;
            if (verbose) {
                System.out.println(ve.toStringNoGt());
            }
            double pDom = ve.getInfoFloat("P_DOM");
            double pAllelic = ve.getInfoFloat("P_ALLELIC");
            double pRec = ve.getInfoFloat("P_REC");
            double pDomCc = ve.getInfoFloat("CC_DOM");
            double pAllelicCc = ve.getInfoFloat("CC_ALL");
            double pRecCc = ve.getInfoFloat("CC_REC");
            if (pAllelic > 0.0) {
                ratio = pAllelic / pAllelicCc;
                if (verbose) {
                    System.out.println("\tAllelic \tRatio: " + ratio + "\tPLINK: " + pAllelic + "\tCalculated: " + pAllelicCc + "\t");
                }
                Assert.assertTrue(ratio < 2.0);
                Assert.assertTrue(ratio >= 1.0);
            }
            if (pDom > 0.0) {
                ratio = pDom / pDomCc;
                if (verbose) {
                    System.out.println("\tDominant\tRatio: " + ratio + "\tPLINK: " + pDom + "\tCalculated: " + pDomCc + "\t");
                }
                Assert.assertTrue(ratio < 2.0);
                Assert.assertTrue(ratio >= 1.0);
            }
            if (pRec > 0.0) {
                ratio = pRec / pRecCc;
                if (verbose) {
                    System.out.println("\tRecessive\tRatio: " + ratio + "\tPLINK: " + pRec + "\tCalculated: " + pRecCc + "\t");
                }
                Assert.assertTrue(ratio < 2.0);
                Assert.assertTrue(ratio >= 1.0);
            }
            if (!verbose) continue;
            System.out.println("");
        }
    }
}

