/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.scop;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Astral {
    private static Map<String, SoftReference<Astral>> instances = new HashMap<String, SoftReference<Astral>>();
    private static final Logger logger = LogManager.getLogger((String)Astral.class.getName());
    private Set<String> names;

    public static Set<String> getRepresentatives(AstralSet cutoff) {
        if (instances.containsKey(cutoff.getId()) && instances.get(cutoff.getId()).get() != null) {
            return instances.get(cutoff.getId()).get().getNames();
        }
        Astral astral = new Astral(cutoff);
        instances.put(cutoff.getId(), new SoftReference<Astral>(astral));
        return astral.getNames();
    }

    public static Set<String> getRepresentatives(String id) {
        return Astral.getRepresentatives(AstralSet.parse(id));
    }

    public Astral(AstralSet cutoff) {
        InputStreamReader reader;
        URL url;
        try {
            url = new URL(cutoff.getUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("The URL was invalid!", e);
        }
        try {
            reader = new InputStreamReader(url.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't open stream to URL " + url, e);
        }
        this.init(reader);
    }

    public Astral(String id, URL url) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(url.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't open stream to URL " + url, e);
        }
        this.init(reader);
    }

    public Astral(String id, Reader reader) {
        this.init(reader);
    }

    public Set<String> getNames() {
        return this.names;
    }

    private void init(Reader reader) {
        this.names = new TreeSet<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(reader);
            logger.info("Reading ASTRAL file...");
            String line = "";
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(">")) continue;
                try {
                    String scopId = line.split("\\s")[0].substring(1);
                    this.names.add(scopId);
                    if (i % 1000 == 0) {
                        logger.debug("Reading ASTRAL line for " + scopId);
                    }
                    ++i;
                }
                catch (RuntimeException e) {
                    logger.error("Couldn't read line " + line, (Throwable)e);
                }
            }
            br.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read the input stream ", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.warn("Could not close stream", (Throwable)e);
                }
            }
        }
    }

    public static enum AstralSet {
        FORTY_175("1.75_40", "http://scop.berkeley.edu/downloads/scopseq-1.75/astral-scopdom-seqres-gd-sel-gs-bib-40-1.75.fa"),
        NINETY_FIVE_175("1.75_95", "http://scop.berkeley.edu/downloads/scopseq-1.75/astral-scopdom-seqres-gd-sel-gs-bib-95-1.75.fa"),
        FORTY_175A("1.75A_40", "http://scop.berkeley.edu/downloads/scopseq-1.75A/astral-scopdom-seqres-gd-sel-gs-bib-40-1.75A.fa"),
        NINETY_FIVE_175A("1.75A_95", "http://scop.berkeley.edu/downloads/scopseq-1.75A/astral-scopdom-seqres-gd-sel-gs-bib-95-1.75A.fa"),
        FORTY_175B("1.75B_40", "http://scop.berkeley.edu/downloads/scopseq-1.75B/astral-scopdom-seqres-gd-sel-gs-bib-40-1.75B.fa"),
        NINETY_FIVE_175B("1.75B_95", "http://scop.berkeley.edu/downloads/scopseq-1.75B/astral-scopdom-seqres-gd-sel-gs-bib-95-1.75B.fa");

        private String id;
        private String url;

        public static AstralSet parse(String str) {
            for (AstralSet c : (AstralSet[])AstralSet.class.getEnumConstants()) {
                if (!c.getId().equals(str)) continue;
                return c;
            }
            throw new IllegalArgumentException("No ASTRAL set with id " + str);
        }

        private AstralSet(String id, String url) {
            this.url = url;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public String toString() {
            return this.id;
        }
    }
}

