/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.ResidueNumber;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.SeqRes2AtomAligner;
import org.biojava.bio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.bio.structure.io.mmcif.chem.PolymerType;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.template.Sequence;

public class ChainImpl
implements Chain,
Serializable {
    private static final long serialVersionUID = 1990171805277911840L;
    public static String DEFAULT_CHAIN_ID = "A";
    String swissprot_id;
    String name = DEFAULT_CHAIN_ID;
    List<Group> groups = new ArrayList<Group>();
    protected List<Group> seqResGroups = new ArrayList<Group>();
    private Long id;
    Compound mol;
    Structure parent;
    Map<String, Integer> pdbResnumMap = new HashMap<String, Integer>();
    String internalChainID = null;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setParent(Structure parent) {
        this.parent = parent;
    }

    @Override
    public Structure getParent() {
        return this.parent;
    }

    @Override
    public Object clone() {
        ChainImpl n = new ChainImpl();
        n.setChainID(this.getChainID());
        n.setSwissprotId(this.getSwissprotId());
        n.setHeader(this.getHeader());
        n.setInternalChainID(this.internalChainID);
        for (int i = 0; i < this.groups.size(); ++i) {
            Group g = this.groups.get(i);
            n.addGroup((Group)g.clone());
        }
        if (this.seqResGroups.size() > 0) {
            ArrayList<Group> tmpSeqRes = new ArrayList<Group>();
            for (int i = 0; i < this.seqResGroups.size(); ++i) {
                Group g = this.seqResGroups.get(i);
                tmpSeqRes.add(g);
            }
            ChainImpl tmp = new ChainImpl();
            tmp.setAtomGroups(tmpSeqRes);
            SeqRes2AtomAligner seqresaligner = new SeqRes2AtomAligner();
            try {
                seqresaligner.mapSeqresRecords(n, tmp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return n;
    }

    @Override
    public void setHeader(Compound mol) {
        this.mol = mol;
    }

    @Override
    public Compound getHeader() {
        return this.mol;
    }

    @Override
    public void setSwissprotId(String sp_id) {
        this.swissprot_id = sp_id;
    }

    @Override
    public String getSwissprotId() {
        return this.swissprot_id;
    }

    @Override
    public void addGroup(Group group) {
        group.setChain(this);
        this.groups.add(group);
        String pdbResnum = null;
        ResidueNumber resNum = group.getResidueNumber();
        if (resNum != null) {
            pdbResnum = resNum.toString();
        }
        if (pdbResnum != null) {
            Integer pos = new Integer(this.groups.size() - 1);
            if (this.pdbResnumMap.containsKey(pdbResnum)) {
                if (group instanceof AminoAcid) {
                    this.pdbResnumMap.put(pdbResnum, pos);
                }
            } else {
                this.pdbResnumMap.put(pdbResnum, pos);
            }
        }
    }

    @Override
    public Group getGroup(int position) {
        return this.groups.get(position);
    }

    @Override
    public Group getAtomGroup(int position) {
        return this.groups.get(position);
    }

    @Override
    public List<Group> getGroups(String type) {
        return this.getAtomGroups(type);
    }

    @Override
    public List<Group> getAtomGroups(String type) {
        ArrayList<Group> tmp = new ArrayList<Group>();
        for (int i = 0; i < this.groups.size(); ++i) {
            Group g = this.groups.get(i);
            if (!g.getType().equals(type)) continue;
            tmp.add(g);
        }
        return tmp;
    }

    @Override
    public List<Group> getGroups() {
        return this.groups;
    }

    @Override
    public List<Group> getAtomGroups() {
        return this.groups;
    }

    @Override
    public void setAtomGroups(List<Group> groups) {
        for (Group g : groups) {
            g.setChain(this);
        }
        this.groups = groups;
    }

    @Override
    public Group[] getGroupsByPDB(String pdbresnumStart, String pdbresnumEnd, boolean ignoreMissing) throws StructureException {
        ResidueNumber start = ResidueNumber.fromString(pdbresnumStart);
        ResidueNumber end = ResidueNumber.fromString(pdbresnumEnd);
        if (!ignoreMissing) {
            return this.getGroupsByPDB(start, end);
        }
        return this.getGroupsByPDB(start, end, ignoreMissing);
    }

    @Override
    public Group[] getGroupsByPDB(ResidueNumber start, ResidueNumber end, boolean ignoreMissing) throws StructureException {
        if (!ignoreMissing) {
            return this.getGroupsByPDB(start, end);
        }
        ArrayList<Group> retlst = new ArrayList<Group>();
        String pdbresnumStart = start.toString();
        String pdbresnumEnd = end.toString();
        int startPos = Integer.MIN_VALUE;
        int endPos = Integer.MAX_VALUE;
        startPos = start.getSeqNum();
        endPos = end.getSeqNum();
        boolean adding = false;
        boolean foundStart = false;
        for (Group g : this.groups) {
            int pos;
            if (g.getResidueNumber().toString().equals(pdbresnumStart)) {
                adding = true;
                foundStart = true;
            }
            if (!(foundStart && adding || (pos = g.getResidueNumber().getSeqNum().intValue()) < startPos)) {
                foundStart = true;
                adding = true;
            }
            if (adding) {
                retlst.add(g);
            }
            if (g.getResidueNumber().toString().equals(pdbresnumEnd)) {
                if (!adding) {
                    throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.name);
                }
                adding = false;
                break;
            }
            if (!adding || (pos = g.getResidueNumber().getSeqNum().intValue()) < endPos) continue;
            adding = false;
            break;
        }
        if (!foundStart) {
            throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.name);
        }
        return retlst.toArray(new Group[retlst.size()]);
    }

    @Override
    public Group getGroupByPDB(String pdbresnum) throws StructureException {
        ResidueNumber resNum = ResidueNumber.fromString(pdbresnum);
        return this.getGroupByPDB(resNum);
    }

    @Override
    public Group getGroupByPDB(ResidueNumber resNum) throws StructureException {
        String pdbresnum = resNum.toString();
        if (this.pdbResnumMap.containsKey(pdbresnum)) {
            Integer pos = this.pdbResnumMap.get(pdbresnum);
            return this.groups.get(pos);
        }
        throw new StructureException("unknown PDB residue number " + pdbresnum + " in chain " + this.name);
    }

    @Override
    public Group[] getGroupsByPDB(String pdbresnumStart, String pdbresnumEnd) throws StructureException {
        ResidueNumber start = ResidueNumber.fromString(pdbresnumStart);
        ResidueNumber end = ResidueNumber.fromString(pdbresnumEnd);
        return this.getGroupsByPDB(start, end);
    }

    @Override
    public Group[] getGroupsByPDB(ResidueNumber start, ResidueNumber end) throws StructureException {
        String pdbresnumStart = start.toString();
        String pdbresnumEnd = end.toString();
        ArrayList<Group> retlst = new ArrayList<Group>();
        Iterator<Group> iter2 = this.groups.iterator();
        boolean adding = false;
        boolean foundStart = false;
        while (iter2.hasNext()) {
            Group g = iter2.next();
            if (g.getResidueNumber().toString().equals(pdbresnumStart)) {
                adding = true;
                foundStart = true;
            }
            if (adding) {
                retlst.add(g);
            }
            if (!g.getResidueNumber().toString().equals(pdbresnumEnd)) continue;
            if (!adding) {
                throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.name);
            }
            adding = false;
            break;
        }
        if (!foundStart) {
            throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.name);
        }
        if (adding) {
            throw new StructureException("did not find end PDB residue number " + pdbresnumEnd + " in chain " + this.name);
        }
        return retlst.toArray(new Group[retlst.size()]);
    }

    @Override
    public int getLength() {
        return this.getAtomLength();
    }

    @Override
    public int getLengthAminos() {
        List<Group> g = this.getAtomGroups("amino");
        return g.size();
    }

    @Override
    public int getSeqResLength() {
        return this.seqResGroups.size();
    }

    @Override
    public void setName(String nam) {
        this.setChainID(nam);
    }

    @Override
    public String getName() {
        return this.getChainID();
    }

    @Override
    public void setChainID(String nam) {
        this.name = nam;
    }

    @Override
    public String getChainID() {
        return this.name;
    }

    @Override
    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuffer str = new StringBuffer();
        str.append("Chain >" + this.getName() + "<" + newline);
        if (this.mol != null && this.mol.getMolName() != null) {
            str.append(this.mol.getMolName()).append(newline);
        }
        str.append("total SEQRES length: " + this.getSeqResGroups().size() + " total ATOM length:" + this.getAtomLength() + " residues " + newline);
        for (int i = 0; i < this.seqResGroups.size(); ++i) {
            Group gr = this.seqResGroups.get(i);
            str.append(gr.toString()).append(newline);
        }
        return str.toString();
    }

    @Override
    public Sequence<?> getBJSequence() {
        String seq2 = this.getSeqResSequence();
        ProteinSequence s = null;
        s = new ProteinSequence(seq2);
        return s;
    }

    @Override
    public String getSequence() {
        return this.getAtomSequence();
    }

    @Override
    public String getAtomSequence() {
        String prop = System.getProperty("loadChemCompInfo");
        if (prop != null && prop.equalsIgnoreCase("true")) {
            List<Group> groups = this.getAtomGroups();
            StringBuffer sequence2 = new StringBuffer();
            for (Group g : groups) {
                ChemComp cc = g.getChemComp();
                if (!PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType()) && !PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType())) continue;
                String oneLetter = ChemCompGroupFactory.getOneLetterCode(cc);
                if (oneLetter == null) {
                    oneLetter = "X";
                }
                sequence2.append(oneLetter);
            }
            return sequence2.toString();
        }
        List<Group> aminos = this.getAtomGroups("amino");
        StringBuffer sequence3 = new StringBuffer();
        for (int i = 0; i < aminos.size(); ++i) {
            AminoAcid a = (AminoAcid)aminos.get(i);
            sequence3.append(a.getAminoType());
        }
        return sequence3.toString();
    }

    @Override
    public String getSeqResSequence() {
        String prop = System.getProperty("loadChemCompInfo");
        if (prop != null && prop.equalsIgnoreCase("true")) {
            StringBuffer str = new StringBuffer();
            for (Group g : this.seqResGroups) {
                ChemComp cc = g.getChemComp();
                if (cc == null) {
                    System.err.println("Could not load ChemComp for group " + g);
                    str.append("X");
                    continue;
                }
                if (PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType()) || PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType())) {
                    String oneLetter = ChemCompGroupFactory.getOneLetterCode(cc);
                    if (oneLetter == null || oneLetter.length() == 0 || oneLetter.equals("?")) {
                        oneLetter = "X";
                    }
                    str.append(oneLetter);
                    continue;
                }
                str.append("X");
            }
            return str.toString();
        }
        StringBuffer str = new StringBuffer();
        for (Group group : this.seqResGroups) {
            if (group instanceof AminoAcid) {
                AminoAcid aa = (AminoAcid)group;
                str.append(aa.getAminoType());
                continue;
            }
            str.append("X");
        }
        return str.toString();
    }

    @Override
    public Group getSeqResGroup(int position) {
        return this.seqResGroups.get(position);
    }

    @Override
    public List<Group> getSeqResGroups(String type) {
        return this.seqResGroups;
    }

    @Override
    public List<Group> getSeqResGroups() {
        return this.seqResGroups;
    }

    @Override
    public void setSeqResGroups(List<Group> groups) {
        for (Group g : groups) {
            g.setChain(this);
        }
        this.seqResGroups = groups;
    }

    protected void addSeqResGroup(Group g) {
        this.seqResGroups.add(g);
    }

    @Override
    public int getAtomLength() {
        return this.groups.size();
    }

    @Override
    public List<Group> getAtomLigands() {
        ArrayList<Group> ligands = new ArrayList<Group>();
        for (Group g : this.groups) {
            if (this.seqResGroups.contains(g) || g.isWater()) continue;
            ligands.add(g);
        }
        return ligands;
    }

    @Override
    public String getInternalChainID() {
        return this.internalChainID;
    }

    @Override
    public void setInternalChainID(String internalChainID) {
        this.internalChainID = internalChainID;
    }
}

