/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleModConstants;
import org.apfloat.internal.DoubleModMath;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class DoubleFactor3NTTStrategy
extends DoubleModMath
implements ParallelNTTStrategy {
    private NTTStrategy factor2Strategy;

    public DoubleFactor3NTTStrategy(NTTStrategy factor2Strategy) {
        this.factor2Strategy = factor2Strategy;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        if (this.factor2Strategy instanceof ParallelNTTStrategy) {
            ((ParallelNTTStrategy)this.factor2Strategy).setParallelRunner(parallelRunner);
        }
    }

    public void transform(DataStorage dataStorage, int modulus) throws ApfloatRuntimeException {
        long length = dataStorage.getSize();
        long power2length = length & -length;
        if (length > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + length + " > " + 0x180000000000L);
        }
        if (length == power2length) {
            this.factor2Strategy.transform(dataStorage, modulus);
        } else {
            assert (length == 3L * power2length);
            this.setModulus(DoubleModConstants.MODULUS[modulus]);
            double w = this.getForwardNthRoot(DoubleModConstants.PRIMITIVE_ROOT[modulus], length);
            double w3 = this.modPow(w, power2length);
            DataStorage dataStorage0 = dataStorage.subsequence(0L, power2length);
            DataStorage dataStorage1 = dataStorage.subsequence(power2length, power2length);
            DataStorage dataStorage2 = dataStorage.subsequence(2L * power2length, power2length);
            this.transformColumns(false, dataStorage0, dataStorage1, dataStorage2, power2length, w, w3);
            this.factor2Strategy.transform(dataStorage0, modulus);
            this.factor2Strategy.transform(dataStorage1, modulus);
            this.factor2Strategy.transform(dataStorage2, modulus);
        }
    }

    public void inverseTransform(DataStorage dataStorage, int modulus, long totalTransformLength) throws ApfloatRuntimeException {
        long length = dataStorage.getSize();
        long power2length = length & -length;
        if (Math.max(length, totalTransformLength) > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(length, totalTransformLength) + " > " + 0x180000000000L);
        }
        if (length == power2length) {
            this.factor2Strategy.inverseTransform(dataStorage, modulus, totalTransformLength);
        } else {
            assert (length == 3L * power2length);
            this.setModulus(DoubleModConstants.MODULUS[modulus]);
            double w = this.getInverseNthRoot(DoubleModConstants.PRIMITIVE_ROOT[modulus], length);
            double w3 = this.modPow(w, power2length);
            DataStorage dataStorage0 = dataStorage.subsequence(0L, power2length);
            DataStorage dataStorage1 = dataStorage.subsequence(power2length, power2length);
            DataStorage dataStorage2 = dataStorage.subsequence(2L * power2length, power2length);
            this.factor2Strategy.inverseTransform(dataStorage0, modulus, totalTransformLength);
            this.factor2Strategy.inverseTransform(dataStorage1, modulus, totalTransformLength);
            this.factor2Strategy.inverseTransform(dataStorage2, modulus, totalTransformLength);
            this.transformColumns(true, dataStorage0, dataStorage1, dataStorage2, power2length, w, w3);
        }
    }

    public long getTransformLength(long size2) {
        return Util.round23up(size2);
    }

    private void transformColumns(boolean isInverse, DataStorage dataStorage0, DataStorage dataStorage1, DataStorage dataStorage2, long size2, double w, double w3) throws ApfloatRuntimeException {
        DataStorage.Iterator iterator0 = dataStorage0.iterator(3, 0L, size2);
        DataStorage.Iterator iterator1 = dataStorage1.iterator(3, 0L, size2);
        DataStorage.Iterator iterator2 = dataStorage2.iterator(3, 0L, size2);
        double ww = this.modMultiply(w, w);
        double w1 = this.negate(this.modDivide(3.0, 2.0));
        double w2 = this.modAdd(w3, this.modDivide(1.0, 2.0));
        double tmp1 = 1.0;
        double tmp2 = 1.0;
        while (size2 > 0L) {
            double x0 = iterator0.getDouble();
            double x1 = iterator1.getDouble();
            double x2 = iterator2.getDouble();
            if (isInverse) {
                x1 = this.modMultiply(x1, tmp1);
                x2 = this.modMultiply(x2, tmp2);
            }
            double t2 = this.modAdd(x1, x2);
            x2 = this.modSubtract(x1, x2);
            x0 = this.modAdd(x0, t2);
            t2 = this.modMultiply(t2, w1);
            x2 = this.modMultiply(x2, w2);
            t2 = this.modAdd(t2, x0);
            x1 = this.modAdd(t2, x2);
            x2 = this.modSubtract(t2, x2);
            if (!isInverse) {
                x1 = this.modMultiply(x1, tmp1);
                x2 = this.modMultiply(x2, tmp2);
            }
            iterator0.setDouble(x0);
            iterator1.setDouble(x1);
            iterator2.setDouble(x2);
            iterator0.next();
            iterator1.next();
            iterator2.next();
            tmp1 = this.modMultiply(tmp1, w);
            tmp2 = this.modMultiply(tmp2, ww);
            --size2;
        }
    }
}

