/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.HetatomImpl;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.PDBParseException;

public class AminoAcidImpl
extends HetatomImpl
implements AminoAcid,
Serializable {
    private static final long serialVersionUID = -6018854413829044230L;
    public static final String type = "amino";
    Character amino_char = null;
    Map<String, String> secstruc = new HashMap<String, String>();
    String recordType = "ATOM";

    @Override
    public String getType() {
        return type;
    }

    @Override
    public void setSecStruc(Map<String, String> secstr) {
        this.secstruc = secstr;
    }

    @Override
    public Map<String, String> getSecStruc() {
        return this.secstruc;
    }

    @Override
    public Atom getN() throws StructureException {
        return this.getAtom("N");
    }

    @Override
    public Atom getCA() throws StructureException {
        return this.getAtom(" CA ");
    }

    @Override
    public Atom getC() throws StructureException {
        return this.getAtom("C");
    }

    @Override
    public Atom getO() throws StructureException {
        return this.getAtom("O");
    }

    @Override
    public Atom getCB() throws StructureException {
        return this.getAtom("CB");
    }

    @Override
    public Character getAminoType() {
        return this.amino_char;
    }

    @Override
    public void setAminoType(Character aa) {
        this.amino_char = aa;
    }

    @Override
    public void setRecordType(String recordName) {
        this.recordType = recordName;
    }

    @Override
    public String getRecordType() {
        return this.recordType;
    }

    @Override
    public String toString() {
        String str = "AminoAcid " + this.recordType + ":" + this.pdb_name + " " + this.amino_char + " " + this.residueNumber + " " + this.pdb_flag + " " + this.recordType;
        if (this.pdb_flag) {
            str = str + " atoms: " + this.atoms.size();
        }
        if (this.altLocs != null) {
            str = str + " has altLocs :" + this.altLocs.size();
        }
        return str;
    }

    @Override
    public void setPDBName(String s) throws PDBParseException {
        if (s != null && s.length() != 3) {
            throw new PDBParseException("amino acid name is not of length 3! (" + s + ")");
        }
        this.pdb_name = s;
    }

    @Override
    public Object clone() {
        AminoAcidImpl n = new AminoAcidImpl();
        n.setPDBFlag(this.has3D());
        n.setResidueNumber(this.getResidueNumber());
        try {
            n.setPDBName(this.getPDBName());
        }
        catch (PDBParseException e) {
            e.printStackTrace();
        }
        n.setAminoType(this.getAminoType());
        n.setRecordType(this.recordType);
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = (Atom)this.atoms.get(i);
            n.addAtom((Atom)atom.clone());
        }
        return n;
    }
}

