/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.base.mdarray.MDDoubleArray;
import ch.systemsx.cisd.base.mdarray.MDFloatArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValue;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.BitSet;

public final class HDF5CompoundMemberInformation
implements Comparable<HDF5CompoundMemberInformation> {
    private final String memberName;
    private final HDF5DataTypeInformation dataTypeInformation;
    private final int offset;
    private final String[] enumValuesOrNull;

    HDF5CompoundMemberInformation(String memberName, HDF5DataTypeInformation dataTypeInformation, int offset, String[] enumValuesOrNull) {
        assert (memberName != null);
        assert (dataTypeInformation != null);
        assert (offset >= 0);
        this.memberName = memberName;
        this.dataTypeInformation = dataTypeInformation;
        this.enumValuesOrNull = enumValuesOrNull;
        this.offset = offset;
    }

    HDF5CompoundMemberInformation(String memberName, HDF5DataTypeInformation dataTypeInformation, int offset) {
        this(memberName, dataTypeInformation, offset, null);
    }

    public String getName() {
        return this.memberName;
    }

    public HDF5DataTypeInformation getType() {
        return this.dataTypeInformation;
    }

    public String[] tryGetEnumValues() {
        return this.enumValuesOrNull;
    }

    public int getOffset() {
        return this.offset;
    }

    public static HDF5CompoundMemberInformation[] create(Class<?> compoundClass, String houseKeepingNameSuffix, HDF5CompoundMemberMapping ... members) {
        assert (compoundClass != null);
        Object[] info = new HDF5CompoundMemberInformation[members.length];
        int offset = 0;
        int i = 0;
        while (i < info.length) {
            info[i] = new HDF5CompoundMemberInformation(members[i].getMemberName(), HDF5CompoundMemberInformation.getTypeInformation(compoundClass, houseKeepingNameSuffix, members[i]), offset);
            offset += ((HDF5CompoundMemberInformation)info[i]).getType().getSize();
            ++i;
        }
        Arrays.sort(info);
        return info;
    }

    private static HDF5DataTypeInformation getTypeInformation(Class<?> compoundClass, String houseKeepingNameSuffix, HDF5CompoundMemberMapping member) {
        HDF5DataTypeInformation typeInfo;
        Class<?> fieldTypeOrNull;
        Field fieldOrNull = member.tryGetField(compoundClass);
        Class<?> clazz = fieldTypeOrNull = fieldOrNull == null ? null : fieldOrNull.getType();
        if (fieldTypeOrNull == Boolean.TYPE) {
            typeInfo = new HDF5DataTypeInformation(HDF5DataClass.BOOLEAN, houseKeepingNameSuffix, 1);
        } else if (fieldTypeOrNull == Byte.TYPE || fieldTypeOrNull == byte[].class || fieldTypeOrNull == byte[][].class || fieldTypeOrNull == MDByteArray.class) {
            typeInfo = new HDF5DataTypeInformation(HDF5DataClass.INTEGER, houseKeepingNameSuffix, 1);
        } else if (fieldTypeOrNull == Short.TYPE || fieldTypeOrNull == short[].class || fieldTypeOrNull == short[][].class || fieldTypeOrNull == MDShortArray.class) {
            typeInfo = new HDF5DataTypeInformation(HDF5DataClass.INTEGER, houseKeepingNameSuffix, 2);
        } else if (fieldTypeOrNull == Integer.TYPE || fieldTypeOrNull == int[].class || fieldTypeOrNull == int[][].class || fieldTypeOrNull == MDIntArray.class) {
            typeInfo = new HDF5DataTypeInformation(HDF5DataClass.INTEGER, houseKeepingNameSuffix, 4);
        } else if (fieldTypeOrNull == Long.TYPE || fieldTypeOrNull == long[].class || fieldTypeOrNull == long[][].class || fieldTypeOrNull == MDLongArray.class) {
            typeInfo = new HDF5DataTypeInformation(HDF5DataClass.INTEGER, houseKeepingNameSuffix, 8);
        } else if (fieldTypeOrNull == BitSet.class) {
            typeInfo = new HDF5DataTypeInformation(HDF5DataClass.BITFIELD, houseKeepingNameSuffix, 8, member.getMemberTypeLength() / 64 + (member.getMemberTypeLength() % 64 != 0 ? 1 : 0));
        } else if (fieldTypeOrNull == Float.TYPE || fieldTypeOrNull == float[].class || fieldTypeOrNull == float[][].class || fieldTypeOrNull == MDFloatArray.class) {
            typeInfo = new HDF5DataTypeInformation(HDF5DataClass.FLOAT, houseKeepingNameSuffix, 4);
        } else if (fieldTypeOrNull == Double.TYPE || fieldTypeOrNull == double[].class || fieldTypeOrNull == double[][].class || fieldTypeOrNull == MDDoubleArray.class) {
            typeInfo = new HDF5DataTypeInformation(HDF5DataClass.FLOAT, houseKeepingNameSuffix, 8);
        } else if (fieldTypeOrNull == String.class || fieldTypeOrNull == char[].class) {
            typeInfo = new HDF5DataTypeInformation(HDF5DataClass.STRING, houseKeepingNameSuffix, member.getMemberTypeLength());
        } else if (fieldTypeOrNull == HDF5EnumerationValue.class) {
            HDF5DataTypeInformation.DataTypeInfoOptions options = new HDF5DataTypeInformation.DataTypeInfoOptions(!"UNKNOWN".equals(member.tryGetEnumerationType().getName()), member.tryGetTypeVariant() != null);
            typeInfo = new HDF5DataTypeInformation(options.knowsDataTypePath() ? HDF5Utils.createDataTypePath("Enum_", houseKeepingNameSuffix, member.tryGetEnumerationType().getName()) : null, options, HDF5DataClass.ENUM, houseKeepingNameSuffix, member.tryGetEnumerationType().getStorageForm().getStorageSize());
            if (options.knowsDataTypeVariant()) {
                typeInfo.setTypeVariant(member.tryGetTypeVariant());
            }
        } else {
            typeInfo = new HDF5DataTypeInformation(HDF5DataClass.OTHER, houseKeepingNameSuffix, -1);
        }
        if (fieldTypeOrNull != null && fieldTypeOrNull.isArray() && fieldTypeOrNull != char[].class || MDAbstractArray.class.isAssignableFrom(fieldTypeOrNull)) {
            typeInfo.setDimensions(member.getMemberTypeDimensions());
        }
        return typeInfo;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HDF5CompoundMemberInformation)) {
            return false;
        }
        HDF5CompoundMemberInformation that = (HDF5CompoundMemberInformation)obj;
        return this.memberName.equals(that.memberName) && this.dataTypeInformation.equals(that.dataTypeInformation);
    }

    public int hashCode() {
        return (1003 + this.memberName.hashCode()) * 59 + this.dataTypeInformation.hashCode();
    }

    public String toString() {
        return String.valueOf(this.memberName) + ":" + this.dataTypeInformation.toString();
    }

    @Override
    public int compareTo(HDF5CompoundMemberInformation o) {
        return this.memberName.compareTo(o.memberName);
    }
}

