/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.utilities;

import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.base.utilities.ResourceUtilities;
import java.io.File;

public final class NativeLibraryUtilities {
    private static final String JNI_LIB_PREFIX = NativeLibraryUtilities.getJNILibPrefixForSystem();
    private static final String JNI_LIB_EXTENSION = NativeLibraryUtilities.getJNILibExtensionForSystem();

    private static String getJNILibPrefixForSystem() {
        return OSUtilities.isWindows() ? "" : "lib";
    }

    private static String getJNILibExtensionForSystem() {
        if (OSUtilities.isMacOS()) {
            return "jnilib";
        }
        if (OSUtilities.isWindows()) {
            return "dll";
        }
        return "so";
    }

    public static boolean loadNativeLibrary(String libraryName) {
        String linkLibNameOrNull = System.getProperty("native.libpath." + libraryName);
        if (linkLibNameOrNull != null) {
            return NativeLibraryUtilities.loadLib(linkLibNameOrNull);
        }
        String linkLibPathOrNull = System.getProperty("native.libpath");
        if (linkLibPathOrNull != null) {
            linkLibNameOrNull = NativeLibraryUtilities.getLibPath(linkLibPathOrNull, libraryName);
            return NativeLibraryUtilities.loadLib(linkLibNameOrNull);
        }
        linkLibNameOrNull = NativeLibraryUtilities.tryCopyNativeLibraryToTempFile(libraryName);
        if (linkLibNameOrNull != null) {
            return NativeLibraryUtilities.loadLib(linkLibNameOrNull);
        }
        return NativeLibraryUtilities.loadSystemLibrary(libraryName);
    }

    private static boolean loadLib(String libPath) {
        File linkLib = new File(libPath);
        if (linkLib.exists() && linkLib.canRead() && linkLib.isFile()) {
            String linkLibNameAbsolute = linkLib.getAbsolutePath();
            try {
                System.load(linkLibNameAbsolute);
                return true;
            }
            catch (Throwable err) {
                System.err.printf("Native library '%s' failed to load:\n", linkLibNameAbsolute);
                err.printStackTrace();
                return false;
            }
        }
        System.err.printf("Native library '%s' does not exist or is not readable.\n", linkLib.getAbsolutePath());
        return false;
    }

    private static boolean loadSystemLibrary(String libName) {
        try {
            System.loadLibrary(libName);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String tryCopyNativeLibraryToTempFile(String libraryName) {
        return ResourceUtilities.tryCopyResourceToTempFile(NativeLibraryUtilities.getLibPath("/native", libraryName), libraryName, ".so");
    }

    private static String getLibPath(String prefix, String libraryName) {
        return String.format("%s/%s/%s/%s%s.%s", prefix, libraryName, OSUtilities.getCompatibleComputerPlatform(), JNI_LIB_PREFIX, libraryName, JNI_LIB_EXTENSION);
    }
}

