/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.args4j.spi;

import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.args4j.spi.Messages;
import ch.systemsx.cisd.args4j.spi.OptionHandler;
import ch.systemsx.cisd.args4j.spi.Parameters;
import ch.systemsx.cisd.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleOptionHandler
extends OptionHandler {
    private final Setter<? super Double> setter;

    public DoubleOptionHandler(Option option, Setter<? super Double> setter) {
        super(option);
        this.setter = setter;
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        this.set(params.getParameter(0));
        return 1;
    }

    @Override
    public void set(String value) throws CmdLineException {
        try {
            this.set(Double.parseDouble(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CmdLineException(Messages.ILLEGAL_OPERAND.format(this.getName(), value));
        }
    }

    protected void set(double value) throws CmdLineException {
        this.setter.addValue((Double)value);
    }

    @Override
    public String getDefaultMetaVariable() {
        return "N";
    }
}

