/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import org.languagetool.rules.Rule;

class RuleLink {
    private static final String DEACTIVATE_URL = "http://languagetool.org/deactivate/";
    private static final String REACTIVATE_URL = "http://languagetool.org/reactivate/";
    private final String urlPrefix;
    private final String id;

    private RuleLink(String urlPrefix, String id) {
        this.urlPrefix = urlPrefix;
        this.id = id;
    }

    static RuleLink buildDeactivationLink(Rule rule) {
        return new RuleLink(DEACTIVATE_URL, rule.getId());
    }

    static RuleLink buildReactivationLink(Rule rule) {
        return new RuleLink(REACTIVATE_URL, rule.getId());
    }

    static RuleLink getFromString(String ruleLink) {
        if (ruleLink.startsWith(DEACTIVATE_URL)) {
            String id = ruleLink.substring(DEACTIVATE_URL.length());
            return new RuleLink(DEACTIVATE_URL, id);
        }
        if (ruleLink.startsWith(REACTIVATE_URL)) {
            String id = ruleLink.substring(REACTIVATE_URL.length());
            return new RuleLink(REACTIVATE_URL, id);
        }
        throw new RuntimeException("Unknown link prefix: " + ruleLink);
    }

    String getId() {
        return this.id;
    }

    public String toString() {
        return this.urlPrefix + this.id;
    }
}

