/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.normalize.segregate;

import java.util.ArrayList;
import java.util.Collection;
import org.encog.util.normalize.DataNormalization;
import org.encog.util.normalize.input.InputField;
import org.encog.util.normalize.segregate.SegregationRange;
import org.encog.util.normalize.segregate.Segregator;

public class RangeSegregator
implements Segregator {
    private InputField sourceField;
    private boolean include;
    private final Collection<SegregationRange> ranges = new ArrayList<SegregationRange>();
    private DataNormalization normalization;

    public RangeSegregator() {
    }

    public RangeSegregator(InputField sourceField, boolean include) {
        this.sourceField = sourceField;
        this.include = include;
    }

    public void addRange(double low, double high, boolean include) {
        SegregationRange range = new SegregationRange(low, high, include);
        this.addRange(range);
    }

    public void addRange(SegregationRange range) {
        this.ranges.add(range);
    }

    @Override
    public DataNormalization getNormalization() {
        return this.normalization;
    }

    public InputField getSourceField() {
        return this.sourceField;
    }

    @Override
    public void init(DataNormalization normalization) {
        this.normalization = normalization;
    }

    @Override
    public boolean shouldInclude() {
        double value = this.sourceField.getCurrentValue();
        for (SegregationRange range : this.ranges) {
            if (!range.inRange(value)) continue;
            return range.isIncluded();
        }
        return this.include;
    }

    @Override
    public void passInit() {
    }
}

