/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.hmm.alog;

import java.util.Iterator;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.hmm.HiddenMarkovModel;

public class ViterbiCalculator {
    private final double[][] delta;
    private final int[][] psy;
    private final int[] stateSequence;
    private double lnProbability;

    public ViterbiCalculator(MLDataSet oseq, HiddenMarkovModel hmm) {
        if (oseq.size() < 1) {
            throw new IllegalArgumentException("Must not have empty sequence");
        }
        this.delta = new double[oseq.size()][hmm.getStateCount()];
        this.psy = new int[oseq.size()][hmm.getStateCount()];
        this.stateSequence = new int[oseq.size()];
        for (int i = 0; i < hmm.getStateCount(); ++i) {
            this.delta[0][i] = -Math.log(hmm.getPi(i)) - Math.log(hmm.getStateDistribution(i).probability(oseq.get(0)));
            this.psy[0][i] = 0;
        }
        Iterator oseqIterator = oseq.iterator();
        if (oseqIterator.hasNext()) {
            oseqIterator.next();
        }
        int t = 1;
        while (oseqIterator.hasNext()) {
            MLDataPair observation = (MLDataPair)oseqIterator.next();
            for (int i = 0; i < hmm.getStateCount(); ++i) {
                this.computeStep(hmm, observation, t, i);
            }
            ++t;
        }
        this.lnProbability = Double.MAX_VALUE;
        for (int i = 0; i < hmm.getStateCount(); ++i) {
            double thisProbability = this.delta[oseq.size() - 1][i];
            if (!(this.lnProbability > thisProbability)) continue;
            this.lnProbability = thisProbability;
            this.stateSequence[oseq.size() - 1] = i;
        }
        this.lnProbability = -this.lnProbability;
        for (int t2 = oseq.size() - 2; t2 >= 0; --t2) {
            this.stateSequence[t2] = this.psy[t2 + 1][this.stateSequence[t2 + 1]];
        }
    }

    private void computeStep(HiddenMarkovModel hmm, MLDataPair o, int t, int j) {
        double minDelta = Double.MAX_VALUE;
        int min_psy = 0;
        for (int i = 0; i < hmm.getStateCount(); ++i) {
            double thisDelta = this.delta[t - 1][i] - Math.log(hmm.getTransitionProbability(i, j));
            if (!(minDelta > thisDelta)) continue;
            minDelta = thisDelta;
            min_psy = i;
        }
        this.delta[t][j] = minDelta - Math.log(hmm.getStateDistribution(j).probability(o));
        this.psy[t][j] = min_psy;
    }

    public double lnProbability() {
        return this.lnProbability;
    }

    public int[] stateSequence() {
        return (int[])this.stateSequence.clone();
    }
}

