/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.ea.score.adjust;

import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.score.AdjustScore;

public class ComplexityAdjustedScore
implements AdjustScore {
    private double complexityPenalty = 0.2;
    private double complexityFullPenalty = 2.0;
    private int complexityPenaltyThreshold = 10;
    private int complexityPentaltyFullThreshold = 50;

    public ComplexityAdjustedScore(int theComplexityPenaltyThreshold, int theComplexityPentaltyFullThreshold, double theComplexityPenalty, double theComplexityFullPenalty) {
        this.complexityPenaltyThreshold = theComplexityPenaltyThreshold;
        this.complexityPentaltyFullThreshold = theComplexityPentaltyFullThreshold;
        this.complexityPenalty = theComplexityPenalty;
        this.complexityFullPenalty = theComplexityFullPenalty;
    }

    public ComplexityAdjustedScore() {
        this(10, 50, 0.2, 2.0);
    }

    @Override
    public double calculateAdjustment(Genome genome) {
        double score = genome.getScore();
        double result = 0.0;
        if (genome.size() > this.complexityPenaltyThreshold) {
            int over = genome.size() - this.complexityPenaltyThreshold;
            int range = this.complexityPentaltyFullThreshold - this.complexityPenaltyThreshold;
            double complexityPenalty = (this.complexityFullPenalty - this.complexityPenalty) / (double)range * (double)over;
            result = score * complexityPenalty;
        }
        return result;
    }

    public double getComplexityPenalty() {
        return this.complexityPenalty;
    }

    public void setComplexityPenalty(double complexityPenalty) {
        this.complexityPenalty = complexityPenalty;
    }

    public double getComplexityFullPenalty() {
        return this.complexityFullPenalty;
    }

    public void setComplexityFullPenalty(double complexityFullPenalty) {
        this.complexityFullPenalty = complexityFullPenalty;
    }

    public int getComplexityPenaltyThreshold() {
        return this.complexityPenaltyThreshold;
    }

    public void setComplexityPenaltyThreshold(int complexityPenaltyThreshold) {
        this.complexityPenaltyThreshold = complexityPenaltyThreshold;
    }

    public int getComplexityPentaltyFullThreshold() {
        return this.complexityPentaltyFullThreshold;
    }

    public void setComplexityPentaltyFullThreshold(int complexityPentaltyFullThreshold) {
        this.complexityPentaltyFullThreshold = complexityPentaltyFullThreshold;
    }
}

