/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.process;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.csv.basic.LoadedRow;
import org.encog.app.analyst.csv.process.ProcessExtension;
import org.encog.app.analyst.script.process.ProcessField;
import org.encog.app.quant.QuantError;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.EncogProgramVariables;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.extension.StandardExtensions;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class AnalystProcess
extends BasicFile {
    private final EncogProgramContext programContext = new EncogProgramContext();
    private final EncogProgramVariables programVariables = new EncogProgramVariables();
    private final List<EncogProgram> expressionFields = new ArrayList<EncogProgram>();
    private ProcessExtension extension;
    private final EncogAnalyst analyst;
    private final int forwardWindowSize;
    private final int backwardWindowSize;

    public AnalystProcess(EncogAnalyst theAnalyst, int theBackwardWindowSize, int theForwardWindowSize) {
        this.analyst = theAnalyst;
        this.backwardWindowSize = theBackwardWindowSize;
        this.forwardWindowSize = theForwardWindowSize;
        StandardExtensions.createAll(this.programContext);
    }

    public void analyze(File inputFile, boolean headers, CSVFormat format) {
        this.setInputFilename(inputFile);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
        this.setAnalyzed(true);
        this.performBasicCounts();
        this.expressionFields.clear();
        this.extension = new ProcessExtension(this.getFormat());
        this.extension.register(this.programContext.getFunctions());
        for (ProcessField field : this.analyst.getScript().getProcess().getFields()) {
            EncogProgram prg = new EncogProgram(this.programContext, this.programVariables);
            prg.setExtraData("ENCOG-ANALYST-PROCESS", this.extension);
            prg.compileExpression(field.getCommand());
            this.expressionFields.add(prg);
        }
    }

    private LoadedRow getNextRow(ReadCSV csv) {
        if (csv.next()) {
            return new LoadedRow(csv);
        }
        return null;
    }

    @Override
    public PrintWriter prepareOutputFile(File outputFile) {
        try {
            PrintWriter tw = new PrintWriter(new FileWriter(outputFile));
            if (this.isProduceOutputHeaders()) {
                int index = 0;
                StringBuilder line = new StringBuilder();
                for (ProcessField field : this.analyst.getScript().getProcess().getFields()) {
                    if (line.length() > 0) {
                        line.append(this.getFormat().getSeparator());
                    }
                    line.append("\"");
                    line.append(field.getName());
                    line.append("\"");
                    ++index;
                }
                tw.println(line.toString());
            }
            return tw;
        }
        catch (IOException e) {
            throw new QuantError(e);
        }
    }

    private void processRow(PrintWriter tw) {
        StringBuilder line = new StringBuilder();
        for (EncogProgram prg : this.expressionFields) {
            ExpressionValue result = prg.evaluate();
            BasicFile.appendSeparator(line, this.getFormat());
            if (result.isString()) {
                line.append("\"");
            }
            line.append(result.toStringValue());
            if (!result.isString()) continue;
            line.append("\"");
        }
        tw.println(line.toString());
    }

    public void process(File outputFile) {
        LoadedRow row;
        this.validateAnalyzed();
        ReadCSV csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getFormat());
        PrintWriter tw = this.prepareOutputFile(outputFile);
        this.extension.init(csv, this.forwardWindowSize, this.backwardWindowSize);
        this.resetStatus();
        while ((row = this.getNextRow(csv)) != null) {
            this.extension.loadRow(row);
            if (this.extension.isDataReady()) {
                this.processRow(tw);
            }
            this.updateStatus(false);
        }
        this.reportDone(false);
        tw.close();
        csv.close();
    }
}

