/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.commands.Cmd;
import org.encog.app.analyst.csv.balance.BalanceCSV;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.util.AnalystReportBridge;
import org.encog.util.csv.CSVFormat;
import org.encog.util.logging.EncogLogging;

public class CmdBalance
extends Cmd {
    public static final String COMMAND_NAME = "BALANCE";

    public CmdBalance(EncogAnalyst analyst) {
        super(analyst);
    }

    @Override
    public boolean executeCommand(String args) {
        String sourceID = this.getProp().getPropertyString("BALANCE:CONFIG_sourceFile");
        String targetID = this.getProp().getPropertyString("BALANCE:CONFIG_targetFile");
        EncogLogging.log(0, "Beginning balance");
        EncogLogging.log(0, "source file:" + sourceID);
        EncogLogging.log(0, "target file:" + targetID);
        File sourceFile = this.getScript().resolveFilename(sourceID);
        File targetFile = this.getScript().resolveFilename(targetID);
        int countPer = this.getProp().getPropertyInt("BALANCE:CONFIG_countPer");
        String targetFieldStr = this.getProp().getPropertyString("BALANCE:CONFIG_balanceField");
        DataField targetFieldDF = this.getAnalyst().getScript().findDataField(targetFieldStr);
        if (targetFieldDF == null) {
            throw new AnalystError("Can't find balance target field: " + targetFieldStr);
        }
        if (!targetFieldDF.isClass()) {
            throw new AnalystError("Can't balance on non-class field: " + targetFieldStr);
        }
        int targetFieldIndex = this.getAnalyst().getScript().findDataFieldIndex(targetFieldDF);
        this.getScript().markGenerated(targetID);
        CSVFormat format = this.getScript().determineFormat();
        BalanceCSV balance = new BalanceCSV();
        balance.setScript(this.getScript());
        this.getAnalyst().setCurrentQuantTask(balance);
        balance.setReport(new AnalystReportBridge(this.getAnalyst()));
        boolean headers = this.getScript().expectInputHeaders(sourceID);
        balance.analyze(sourceFile, headers, format);
        balance.setProduceOutputHeaders(true);
        balance.process(targetFile, targetFieldIndex, countPer);
        this.getAnalyst().setCurrentQuantTask(null);
        return balance.shouldStop();
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }
}

