/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene42;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.UndeadNormsProducer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;

@Deprecated
public class Lucene42FieldInfosFormat
extends FieldInfosFormat {
    static final String EXTENSION = "fnm";
    static final String CODEC_NAME = "Lucene42FieldInfos";
    static final int FORMAT_START = 0;
    static final int FORMAT_CURRENT = 0;
    static final byte IS_INDEXED = 1;
    static final byte STORE_TERMVECTOR = 2;
    static final byte STORE_OFFSETS_IN_POSTINGS = 4;
    static final byte OMIT_NORMS = 16;
    static final byte STORE_PAYLOADS = 32;
    static final byte OMIT_TERM_FREQ_AND_POSITIONS = 64;
    static final byte OMIT_POSITIONS = -128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext iocontext) throws IOException {
        FieldInfos fieldInfos;
        block8: {
            IndexInput input;
            block7: {
                String fileName = IndexFileNames.segmentFileName((String)segmentInfo.name, (String)"", (String)EXTENSION);
                input = directory.openInput(fileName, iocontext);
                boolean success = false;
                try {
                    CodecUtil.checkHeader((DataInput)input, (String)CODEC_NAME, (int)0, (int)0);
                    int size = input.readVInt();
                    FieldInfo[] infos = new FieldInfo[size];
                    for (int i = 0; i < size; ++i) {
                        boolean storePayloads;
                        String name = input.readString();
                        int fieldNumber = input.readVInt();
                        if (fieldNumber < 0) {
                            throw new CorruptIndexException("invalid field number for field: " + name + ", fieldNumber=" + fieldNumber, (DataInput)input);
                        }
                        byte bits = input.readByte();
                        boolean isIndexed = (bits & 1) != 0;
                        boolean storeTermVector = (bits & 2) != 0;
                        boolean omitNorms = (bits & 0x10) != 0;
                        boolean bl = storePayloads = (bits & 0x20) != 0;
                        IndexOptions indexOptions = !isIndexed ? IndexOptions.NONE : ((bits & 0x40) != 0 ? IndexOptions.DOCS : ((bits & 0xFFFFFF80) != 0 ? IndexOptions.DOCS_AND_FREQS : ((bits & 4) != 0 ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS)));
                        byte val = input.readByte();
                        DocValuesType docValuesType = Lucene42FieldInfosFormat.getDocValuesType(input, (byte)(val & 0xF));
                        DocValuesType normsType = Lucene42FieldInfosFormat.getDocValuesType(input, (byte)(val >>> 4 & 0xF));
                        Map attributes = input.readStringStringMap();
                        if (isIndexed && !omitNorms && normsType == DocValuesType.NONE) {
                            UndeadNormsProducer.setUndead(attributes);
                        }
                        infos[i] = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, -1L, Collections.unmodifiableMap(attributes));
                        infos[i].checkConsistency();
                    }
                    CodecUtil.checkEOF((IndexInput)input);
                    FieldInfos fieldInfos2 = new FieldInfos(infos);
                    success = true;
                    fieldInfos = fieldInfos2;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        input.close();
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{input});
                    }
                    throw throwable;
                }
                input.close();
                break block8;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{input});
        }
        return fieldInfos;
    }

    private static DocValuesType getDocValuesType(IndexInput input, byte b) throws IOException {
        if (b == 0) {
            return DocValuesType.NONE;
        }
        if (b == 1) {
            return DocValuesType.NUMERIC;
        }
        if (b == 2) {
            return DocValuesType.BINARY;
        }
        if (b == 3) {
            return DocValuesType.SORTED;
        }
        if (b == 4) {
            return DocValuesType.SORTED_SET;
        }
        throw new CorruptIndexException("invalid docvalues byte: " + b, (DataInput)input);
    }

    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        throw new UnsupportedOperationException("this codec can only be used for reading");
    }
}

