/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;

public class AggregatedFeatureGenerator
implements AdaptiveFeatureGenerator {
    private Collection<AdaptiveFeatureGenerator> generators;

    public AggregatedFeatureGenerator(AdaptiveFeatureGenerator ... generators) {
        for (AdaptiveFeatureGenerator generator : generators) {
            if (generator != null) continue;
            throw new IllegalArgumentException("null values in generators are not permitted!");
        }
        this.generators = new ArrayList<AdaptiveFeatureGenerator>(generators.length);
        Collections.addAll(this.generators, generators);
        this.generators = Collections.unmodifiableCollection(this.generators);
    }

    public AggregatedFeatureGenerator(Collection<AdaptiveFeatureGenerator> generators) {
        this(generators.toArray(new AdaptiveFeatureGenerator[generators.size()]));
    }

    @Override
    public void clearAdaptiveData() {
        for (AdaptiveFeatureGenerator generator : this.generators) {
            generator.clearAdaptiveData();
        }
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        for (AdaptiveFeatureGenerator generator : this.generators) {
            generator.createFeatures(features, tokens, index, previousOutcomes);
        }
    }

    @Override
    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
        for (AdaptiveFeatureGenerator generator : this.generators) {
            generator.updateAdaptiveData(tokens, outcomes);
        }
    }

    public Collection<AdaptiveFeatureGenerator> getGenerators() {
        return this.generators;
    }
}

