/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomDataImpl;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmpiricalDistribution
implements Serializable {
    public static final int DEFAULT_BIN_COUNT = 1000;
    private static final long serialVersionUID = 5729073523949762654L;
    private final List<SummaryStatistics> binStats;
    private SummaryStatistics sampleStats = null;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private double delta = 0.0;
    private final int binCount;
    private boolean loaded = false;
    private double[] upperBounds = null;
    private final RandomDataImpl randomData;

    public EmpiricalDistribution() {
        this(1000, new RandomDataImpl());
    }

    public EmpiricalDistribution(int binCount) {
        this(binCount, new RandomDataImpl());
    }

    public EmpiricalDistribution(int binCount, RandomGenerator generator) {
        this.binCount = binCount;
        this.randomData = new RandomDataImpl(generator);
        this.binStats = new ArrayList<SummaryStatistics>();
    }

    public EmpiricalDistribution(RandomGenerator generator) {
        this(1000, generator);
    }

    public EmpiricalDistribution(int binCount, RandomDataImpl randomData) {
        this.binCount = binCount;
        this.randomData = randomData;
        this.binStats = new ArrayList<SummaryStatistics>();
    }

    public EmpiricalDistribution(RandomDataImpl randomData) {
        this(1000, randomData);
    }

    public void load(double[] in) throws NullArgumentException {
        ArrayDataAdapter da = new ArrayDataAdapter(in);
        try {
            ((DataAdapter)da).computeStats();
            this.fillBinStats(in);
        }
        catch (IOException e) {
            throw new MathIllegalStateException(e, LocalizedFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
        }
        this.loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL url) throws IOException, NullArgumentException {
        MathUtils.checkNotNull(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        try {
            StreamDataAdapter da = new StreamDataAdapter(in);
            ((DataAdapter)da).computeStats();
            if (this.sampleStats.getN() == 0L) {
                throw new ZeroException((Localizable)LocalizedFormats.URL_CONTAINS_NO_DATA, url);
            }
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            this.fillBinStats(in);
            this.loaded = true;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException, NullArgumentException {
        MathUtils.checkNotNull(file);
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            StreamDataAdapter da = new StreamDataAdapter(in);
            ((DataAdapter)da).computeStats();
            in = new BufferedReader(new FileReader(file));
            this.fillBinStats(in);
            this.loaded = true;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void fillBinStats(Object in) throws IOException {
        this.min = this.sampleStats.getMin();
        this.max = this.sampleStats.getMax();
        this.delta = (this.max - this.min) / Double.valueOf(this.binCount);
        if (!this.binStats.isEmpty()) {
            this.binStats.clear();
        }
        for (int i = 0; i < this.binCount; ++i) {
            SummaryStatistics stats = new SummaryStatistics();
            this.binStats.add(i, stats);
        }
        DataAdapterFactory aFactory = new DataAdapterFactory();
        DataAdapter da = aFactory.getAdapter(in);
        da.computeBinStats();
        this.upperBounds = new double[this.binCount];
        this.upperBounds[0] = (double)this.binStats.get(0).getN() / (double)this.sampleStats.getN();
        for (int i = 1; i < this.binCount - 1; ++i) {
            this.upperBounds[i] = this.upperBounds[i - 1] + (double)this.binStats.get(i).getN() / (double)this.sampleStats.getN();
        }
        this.upperBounds[this.binCount - 1] = 1.0;
    }

    private int findBin(double value) {
        return FastMath.min(FastMath.max((int)FastMath.ceil((value - this.min) / this.delta) - 1, 0), this.binCount - 1);
    }

    public double getNextValue() throws MathIllegalStateException {
        if (!this.loaded) {
            throw new MathIllegalStateException(LocalizedFormats.DISTRIBUTION_NOT_LOADED, new Object[0]);
        }
        double x = this.randomData.nextUniform(0.0, 1.0);
        for (int i = 0; i < this.binCount; ++i) {
            SummaryStatistics stats;
            if (!(x <= this.upperBounds[i]) || (stats = this.binStats.get(i)).getN() <= 0L) continue;
            if (stats.getStandardDeviation() > 0.0) {
                return this.randomData.nextGaussian(stats.getMean(), stats.getStandardDeviation());
            }
            return stats.getMean();
        }
        throw new MathIllegalStateException(LocalizedFormats.NO_BIN_SELECTED, new Object[0]);
    }

    public StatisticalSummary getSampleStats() {
        return this.sampleStats;
    }

    public int getBinCount() {
        return this.binCount;
    }

    public List<SummaryStatistics> getBinStats() {
        return this.binStats;
    }

    public double[] getUpperBounds() {
        double[] binUpperBounds = new double[this.binCount];
        binUpperBounds[0] = this.min + this.delta;
        for (int i = 1; i < this.binCount - 1; ++i) {
            binUpperBounds[i] = binUpperBounds[i - 1] + this.delta;
        }
        binUpperBounds[this.binCount - 1] = this.max;
        return binUpperBounds;
    }

    public double[] getGeneratorUpperBounds() {
        int len = this.upperBounds.length;
        double[] out = new double[len];
        System.arraycopy(this.upperBounds, 0, out, 0, len);
        return out;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void reSeed(long seed) {
        this.randomData.reSeed(seed);
    }

    private class ArrayDataAdapter
    extends DataAdapter {
        private double[] inputArray;

        public ArrayDataAdapter(double[] in) throws NullArgumentException {
            MathUtils.checkNotNull(in);
            this.inputArray = in;
        }

        public void computeStats() throws IOException {
            EmpiricalDistribution.this.sampleStats = new SummaryStatistics();
            for (int i = 0; i < this.inputArray.length; ++i) {
                EmpiricalDistribution.this.sampleStats.addValue(this.inputArray[i]);
            }
        }

        public void computeBinStats() throws IOException {
            for (int i = 0; i < this.inputArray.length; ++i) {
                SummaryStatistics stats = (SummaryStatistics)EmpiricalDistribution.this.binStats.get(EmpiricalDistribution.this.findBin(this.inputArray[i]));
                stats.addValue(this.inputArray[i]);
            }
        }
    }

    private class StreamDataAdapter
    extends DataAdapter {
        private BufferedReader inputStream;

        public StreamDataAdapter(BufferedReader in) {
            this.inputStream = in;
        }

        public void computeBinStats() throws IOException {
            String str = null;
            double val = 0.0;
            while ((str = this.inputStream.readLine()) != null) {
                val = Double.parseDouble(str);
                SummaryStatistics stats = (SummaryStatistics)EmpiricalDistribution.this.binStats.get(EmpiricalDistribution.this.findBin(val));
                stats.addValue(val);
            }
            this.inputStream.close();
            this.inputStream = null;
        }

        public void computeStats() throws IOException {
            String str = null;
            double val = 0.0;
            EmpiricalDistribution.this.sampleStats = new SummaryStatistics();
            while ((str = this.inputStream.readLine()) != null) {
                val = Double.valueOf(str);
                EmpiricalDistribution.this.sampleStats.addValue(val);
            }
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    private class DataAdapterFactory {
        private DataAdapterFactory() {
        }

        public DataAdapter getAdapter(Object in) {
            if (in instanceof BufferedReader) {
                BufferedReader inputStream = (BufferedReader)in;
                return new StreamDataAdapter(inputStream);
            }
            if (in instanceof double[]) {
                double[] inputArray = (double[])in;
                return new ArrayDataAdapter(inputArray);
            }
            throw new MathIllegalArgumentException(LocalizedFormats.INPUT_DATA_FROM_UNSUPPORTED_DATASOURCE, in.getClass().getName(), BufferedReader.class.getName(), double[].class.getName());
        }
    }

    private abstract class DataAdapter {
        private DataAdapter() {
        }

        public abstract void computeBinStats() throws IOException;

        public abstract void computeStats() throws IOException;
    }
}

