/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.net;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.CookieHandler;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ProgressMonitorInputStream;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.net.CookieHandlerImpl;

public class URLDownload {
    private URL source;
    private URLConnection con = null;
    private File dest;
    private Component parent;
    private String mimeType = null;
    private String content = null;
    private String encoding = null;
    private CookieHandler cm;

    public URLDownload(URL _source) {
        this.source = _source;
        this.dest = null;
        this.parent = null;
        this.setCookieHandler();
    }

    public URLDownload(Component _parent, URL _source, File _dest) {
        this.source = _source;
        this.dest = _dest;
        this.parent = _parent;
        this.setCookieHandler();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private void setCookieHandler() {
        try {
            this.cm = CookieHandler.getDefault();
            if (this.cm == null) {
                this.cm = new CookieHandlerImpl();
                CookieHandler.setDefault(this.cm);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public URLConnection getURLConnection() {
        return this.con;
    }

    public String getStringContent() {
        return this.content;
    }

    public void openConnectionOnly() throws IOException {
        this.con = this.source.openConnection();
        this.con.setRequestProperty("User-Agent", "Jabref");
        this.mimeType = this.con.getContentType();
    }

    public void download() throws IOException {
        if (this.con == null) {
            this.con = this.source.openConnection();
            this.con.setRequestProperty("User-Agent", "Jabref");
            this.mimeType = this.con.getContentType();
        }
        if (this.dest != null) {
            this.downloadToFile();
        } else {
            this.downloadToString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadToString() throws IOException {
        BufferedInputStream input = new BufferedInputStream(this.con.getInputStream());
        StringWriter output = new StringWriter();
        try {
            this.copy((InputStream)input, output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)input).close();
                ((Writer)output).close();
            }
            catch (Exception exception) {}
        }
        this.content = ((Object)output).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadToFile() throws IOException {
        BufferedInputStream input = new BufferedInputStream(this.con.getInputStream());
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.dest));
        try {
            this.copy((InputStream)input, output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)input).close();
                ((OutputStream)output).close();
            }
            catch (Exception exception) {}
        }
    }

    public void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        ProgressMonitorInputStream _in = new ProgressMonitorInputStream(this.parent, "Downloading " + this.source.toString(), in);
        byte[] buffer = new byte[512];
        while ((bytesRead = ((InputStream)_in).read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public void copy(InputStream in, Writer out) throws IOException {
        String line;
        ProgressMonitorInputStream _in = new ProgressMonitorInputStream(this.parent, "Downloading " + this.source.toString(), in);
        Reader r = this.encoding != null ? new InputStreamReader((InputStream)_in, this.encoding) : ImportFormatReader.getReaderDefaultEncoding(_in);
        BufferedReader read = new BufferedReader(r);
        while ((line = read.readLine()) != null) {
            out.write(line);
            out.write("\n");
        }
    }
}

