/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.Util;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.CaseKeeper;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;

public class DOItoBibTeXFetcher
implements EntryFetcher {
    private static final String URL_PATTERN = "http://dx.doi.org/%s";
    final CaseKeeper caseKeeper = new CaseKeeper();

    @Override
    public void stopFetching() {
    }

    @Override
    public boolean processQuery(String query, ImportInspector inspector, OutputPrinter status) {
        String bibtexString;
        URLConnection conn;
        URL url;
        String q;
        try {
            q = URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            status.setStatus(Globals.lang("Error"));
            e.printStackTrace();
            return false;
        }
        String urlString = String.format(URL_PATTERN, q);
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        try {
            conn = url.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        conn.setRequestProperty("Accept", "text/bibliography; style=bibtex");
        try {
            bibtexString = Util.getResults(conn);
        }
        catch (FileNotFoundException e) {
            status.showMessage(Globals.lang("Unknown DOI: '%0'.", query), Globals.lang("Get BibTeX entry from DOI"), 1);
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        BibtexEntry entry = BibtexParser.singleFromString(bibtexString);
        if (entry != null) {
            String title = entry.getField("title");
            if (title != null) {
                if (Globals.prefs.getBoolean("useCaseKeeperOnSearch")) {
                    title = this.caseKeeper.format(title);
                }
                entry.setField("title", title);
            }
            inspector.addEntry(entry);
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return "DOI to BibTeX";
    }

    @Override
    public String getKeyName() {
        return "DOItoBibTeX";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getHelpPage() {
        return "DOItoBibTeXHelp.html";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }
}

