/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.sf.jabref.autocompleter.AbstractAutoCompleter;

public class AutoCompleteListener
extends KeyAdapter
implements FocusListener {
    private static Logger logger = Logger.getLogger(AutoCompleteListener.class.getName());
    AbstractAutoCompleter completer;
    protected String toSetIn = null;
    protected String lastBeginning = null;
    protected int lastCaretPosition = -1;
    protected String[] lastCompletions = null;
    protected int lastShownCompletion = 0;
    protected boolean consumeEnterKey = true;
    protected FocusListener nextFocusListener = null;
    static final int ANY_NAME = 0;
    static final int FIRST_NAME = 1;
    static final int LAST_NAME = 2;

    public AutoCompleteListener(AbstractAutoCompleter completer) {
        this.completer = completer;
    }

    public void setNextFocusListener(FocusListener listener) {
        this.nextFocusListener = listener;
    }

    public void setConsumeEnterKey(boolean t) {
        this.consumeEnterKey = t;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.toSetIn != null && e.getKeyCode() == 10) {
            JTextComponent comp = (JTextComponent)e.getSource();
            this.lastBeginning = this.lastCompletions[this.lastShownCompletion];
            int end = comp.getSelectionEnd();
            comp.select(end, end);
            this.toSetIn = null;
            if (this.consumeEnterKey) {
                e.consume();
            }
            return;
        }
        if (e.getKeyCode() == 34 && this.toSetIn != null) {
            this.cycle((JTextComponent)e.getSource(), 1);
            e.consume();
        } else if (e.getKeyCode() == 33 && this.toSetIn != null) {
            this.cycle((JTextComponent)e.getSource(), -1);
            e.consume();
        } else if (e.getKeyChar() == '\uffff') {
            if (e.getKeyCode() != 16) {
                this.resetAutoCompletion();
            } else {
                logger.finest("special case: shift pressed. No action.");
            }
        } else {
            logger.finest("special case: defined character, but not caught above");
        }
    }

    private void cycle(JTextComponent comp, int increment) {
        assert (this.lastCompletions != null);
        assert (this.lastCompletions.length > 0);
        this.lastShownCompletion += increment;
        if (this.lastShownCompletion >= this.lastCompletions.length) {
            this.lastShownCompletion = 0;
        } else if (this.lastShownCompletion < 0) {
            this.lastShownCompletion = this.lastCompletions.length - 1;
        }
        String sno = this.lastCompletions[this.lastShownCompletion];
        this.toSetIn = sno.substring(this.lastBeginning.length() - 1);
        StringBuffer alltext = new StringBuffer(comp.getText());
        int oldSelectionStart = comp.getSelectionStart();
        int oldSelectionEnd = comp.getSelectionEnd();
        int startPos = comp.getSelectionStart() - this.lastBeginning.length();
        alltext.delete(startPos, oldSelectionStart);
        alltext.insert(startPos, sno.subSequence(0, this.lastBeginning.length()));
        int deletedChars = oldSelectionEnd - oldSelectionStart;
        alltext.delete(oldSelectionStart, oldSelectionEnd);
        alltext.insert(oldSelectionStart, this.toSetIn.substring(1));
        comp.setText(alltext.toString());
        comp.select(oldSelectionStart, oldSelectionStart + this.toSetIn.length() - 1);
        this.lastCaretPosition = comp.getCaretPosition();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setUnmodifiedTypedLetters(JTextComponent comp, boolean lastBeginningContainsTypedCharacter, boolean wordSeperatorTyped) {
        if (this.lastBeginning == null) {
            logger.finest("no last beginning");
            return;
        }
        logger.finest("lastBeginning: >" + this.lastBeginning + "<");
        if (comp.getSelectedText() == null) {
            if (!wordSeperatorTyped) return;
            logger.finest("replacing complete word");
        } else {
            logger.finest("selected text " + comp.getSelectedText() + " will be removed");
            comp.replaceSelection("");
        }
        this.lastCaretPosition = comp.getCaretPosition();
        int endIndex = this.lastCaretPosition - this.lastBeginning.length();
        if (lastBeginningContainsTypedCharacter) {
            ++endIndex;
        }
        String text = comp.getText();
        comp.setText(text.substring(0, endIndex).concat(this.lastBeginning).concat(text.substring(this.lastCaretPosition)));
        if (lastBeginningContainsTypedCharacter) {
            ++this.lastCaretPosition;
        }
        comp.setCaretPosition(this.lastCaretPosition);
        this.lastBeginning = null;
    }

    private void startCompletion(StringBuffer currentword, KeyEvent e) {
        String cWord;
        JTextComponent comp = (JTextComponent)e.getSource();
        String[] completed = this.findCompletions(currentword.toString(), comp);
        String prefix = this.completer.getPrefix();
        String string = cWord = prefix != null && prefix.length() > 0 ? currentword.toString().substring(prefix.length()) : currentword.toString();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("startCompletion");
            logger.finest("currentword: >" + currentword + "<");
            logger.finest("prefix: >" + prefix + "<");
            logger.finest("cword: >" + cWord + "<");
        }
        int no = 0;
        if (completed != null && completed.length > 0) {
            this.lastShownCompletion = 0;
            this.lastCompletions = completed;
            String sno = completed[no];
            this.toSetIn = sno.substring(cWord.length() - 1);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("toSetIn: >" + this.toSetIn + "<");
            }
            StringBuffer alltext = new StringBuffer(comp.getText());
            int cp = comp.getCaretPosition();
            alltext.insert(cp, this.toSetIn);
            comp.setText(alltext.toString());
            comp.setCaretPosition(cp);
            comp.select(cp + 1, cp + 1 + sno.length() - cWord.length());
            e.consume();
            this.lastCaretPosition = comp.getCaretPosition();
            char ch = e.getKeyChar();
            logger.finest("Appending >" + ch + "<");
            this.lastBeginning = cWord.length() <= 1 ? Character.toString(ch) : cWord.substring(0, cWord.length() - 1).concat(Character.toString(ch));
            return;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        logger.finest("key typed event caught");
        char ch = e.getKeyChar();
        if (ch == '\n') {
            return;
        }
        if ((e.getModifiers() | 1) == 1) {
            if (Character.isLetter(ch) || Character.isDigit(ch) || Character.isWhitespace(ch) && this.completer.isSingleUnitField()) {
                JTextComponent comp = (JTextComponent)e.getSource();
                if (logger.isLoggable(Level.FINEST)) {
                    if (this.toSetIn == null) {
                        logger.finest("toSetIn: NULL");
                    } else {
                        logger.finest("toSetIn: >" + this.toSetIn + "<");
                    }
                }
                if (this.toSetIn != null && this.toSetIn.length() > 1 && ch == this.toSetIn.charAt(1)) {
                    logger.finest("cont");
                    this.toSetIn = this.toSetIn.substring(1);
                    if (this.toSetIn.length() > 0) {
                        int cp = comp.getCaretPosition();
                        comp.select(cp + 1 - this.toSetIn.length(), cp);
                        this.lastBeginning = this.lastBeginning + ch;
                        e.consume();
                        this.lastCaretPosition = comp.getCaretPosition();
                        this.lastCompletions = this.findCompletions(this.lastBeginning, comp);
                        this.lastShownCompletion = 0;
                        for (int i = 0; i < this.lastCompletions.length; ++i) {
                            String lastCompletion = this.lastCompletions[i];
                            if (!lastCompletion.endsWith(this.toSetIn)) continue;
                            this.lastShownCompletion = i;
                            break;
                        }
                        if (this.toSetIn.length() < 2) {
                            String text = comp.getText();
                            comp.setText(text.substring(0, this.lastCaretPosition - this.lastBeginning.length()) + this.lastBeginning + text.substring(this.lastCaretPosition));
                            this.toSetIn = null;
                        }
                        return;
                    }
                }
                if (this.toSetIn != null && (this.toSetIn.length() <= 1 || ch != this.toSetIn.charAt(1))) {
                    String[] completed;
                    this.lastBeginning = this.lastBeginning + ch;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("discont");
                        logger.finest("toSetIn: >" + this.toSetIn + "<");
                        logger.finest("lastBeginning: >" + this.lastBeginning + "<");
                    }
                    if ((completed = this.findCompletions(this.lastBeginning, comp)) != null && completed.length > 0) {
                        this.lastShownCompletion = 0;
                        this.lastCompletions = completed;
                        String sno = completed[0];
                        int lastLen = this.toSetIn.length() - 1;
                        this.toSetIn = sno.substring(this.lastBeginning.length() - 1);
                        String text = comp.getText();
                        comp.setText(text.substring(0, this.lastCaretPosition - lastLen - this.lastBeginning.length() + 1) + sno + text.substring(this.lastCaretPosition));
                        int startSelect = this.lastCaretPosition + 1 - lastLen;
                        int endSelect = this.lastCaretPosition + this.toSetIn.length() - lastLen;
                        comp.select(startSelect, endSelect);
                        this.lastCaretPosition = comp.getCaretPosition();
                        e.consume();
                        return;
                    }
                    this.setUnmodifiedTypedLetters(comp, true, false);
                    e.consume();
                    this.toSetIn = null;
                    return;
                }
                logger.finest("case else");
                comp.replaceSelection("");
                StringBuffer currentword = this.getCurrentWord(comp);
                if (currentword == null) {
                    currentword = new StringBuffer();
                }
                assert (!Character.isISOControl(ch));
                currentword.append(ch);
                this.startCompletion(currentword, e);
                return;
            }
            if (Character.isWhitespace(ch)) {
                assert (!this.completer.isSingleUnitField());
                logger.finest("whitespace && !singleUnitField");
                this.setUnmodifiedTypedLetters((JTextComponent)e.getSource(), false, true);
                this.resetAutoCompletion();
                return;
            }
            logger.finest("No letter/digit/whitespace or CHAR_UNDEFINED");
            this.setUnmodifiedTypedLetters((JTextComponent)e.getSource(), false, !Character.isISOControl(ch));
            this.resetAutoCompletion();
            return;
        }
        this.resetAutoCompletion();
    }

    private void resetAutoCompletion() {
        logger.finest("Resetting autocompletion");
        this.toSetIn = null;
        this.lastBeginning = null;
    }

    protected String[] findCompletions(String beginning, JTextComponent comp) {
        return this.completer.complete(beginning);
    }

    protected StringBuffer getCurrentWord(JTextComponent comp) {
        StringBuffer res = new StringBuffer();
        try {
            String upToCaret = comp.getText(0, comp.getCaretPosition());
            if (!this.completer.isSingleUnitField()) {
                int piv;
                if (comp.getCaretPosition() < comp.getText().length() && Character.isWhitespace(comp.getText().charAt(comp.getCaretPosition()))) {
                    return null;
                }
                for (piv = upToCaret.length() - 1; piv >= 0 && !Character.isWhitespace(upToCaret.charAt(piv)); --piv) {
                }
                res.append(upToCaret.substring(piv + 1));
            } else {
                res.append(upToCaret);
            }
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
        return res;
    }

    protected int findNamePositionStatus(JTextComponent comp) {
        try {
            String upToCaret = comp.getText(0, comp.getCaretPosition());
            upToCaret = upToCaret.substring(upToCaret.lastIndexOf(" and ") + 1);
            int commaIndex = upToCaret.indexOf(44);
            if (commaIndex < 0) {
                return 0;
            }
            return 1;
        }
        catch (BadLocationException ex) {
            return 0;
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (this.nextFocusListener != null) {
            this.nextFocusListener.focusGained(event);
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (this.toSetIn != null) {
            JTextComponent comp = (JTextComponent)event.getSource();
            this.clearCurrentSuggestion(comp);
        }
        if (this.nextFocusListener != null) {
            this.nextFocusListener.focusLost(event);
        }
    }

    public void clearCurrentSuggestion(JTextComponent comp) {
        if (this.toSetIn != null) {
            int selStart = comp.getSelectionStart();
            String text = comp.getText();
            comp.setText(text.substring(0, selStart) + text.substring(comp.getSelectionEnd()));
            comp.setCaretPosition(selStart);
            this.lastCompletions = null;
            this.lastShownCompletion = 0;
            this.lastCaretPosition = -1;
            this.toSetIn = null;
        }
    }
}

