/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.export.ExportFileFilter;
import net.sf.jabref.export.ExportFormat;
import net.sf.jabref.export.IExportFormat;
import net.sf.jabref.export.IExportFormatProvider;
import net.sf.jabref.export.MSBibExportFormat;
import net.sf.jabref.export.ModsExportFormat;
import net.sf.jabref.export.MySQLExport;
import net.sf.jabref.export.OpenDocumentSpreadsheetCreator;
import net.sf.jabref.export.OpenOfficeDocumentCreator;
import net.sf.jabref.export.PluginBasedExportFormat;
import net.sf.jabref.export.PostgreSQLExport;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.core.JabRefPlugin;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;

public class ExportFormats {
    private static Map<String, IExportFormat> exportFormats = new TreeMap<String, IExportFormat>();
    public static int entryNumber = 0;

    public static void initAllExports() {
        exportFormats.clear();
        ExportFormats.putFormat(new ExportFormat(Globals.lang("HTML"), "html", "html", null, ".html"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("Simple HTML"), "simplehtml", "simplehtml", null, ".html"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("DocBook").concat(" 4.4"), "docbook", "docbook", null, ".xml"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("DIN 1505"), "din1505", "din1505winword", "din1505", ".rtf"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("BibTeXML"), "bibtexml", "bibtexml", null, ".xml"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("BibO RDF"), "bibordf", "bibordf", null, ".rdf"));
        ExportFormats.putFormat(new ModsExportFormat());
        ExportFormats.putFormat(new ExportFormat(Globals.lang("HTML table"), "tablerefs", "tablerefs", "tablerefs", ".html"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("HTML list"), "listrefs", "listrefs", "listrefs", ".html"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("HTML table (with Abstract & BibTeX)"), "tablerefsabsbib", "tablerefsabsbib", "tablerefsabsbib", ".html"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("Harvard RTF"), "harvard", "harvard", "harvard", ".rtf"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("Endnote"), "endnote", "EndNote", "endnote", ".txt"));
        ExportFormats.putFormat(new ExportFormat(Globals.lang("OpenOffice CSV"), "oocsv", "openoffice-csv", "openoffice", ".csv"));
        ExportFormat ef = new ExportFormat(Globals.lang("RIS"), "ris", "ris", "ris", ".ris");
        ef.encoding = "UTF-8";
        ExportFormats.putFormat(ef);
        ExportFormats.putFormat(new OpenOfficeDocumentCreator());
        ExportFormats.putFormat(new OpenDocumentSpreadsheetCreator());
        ExportFormats.putFormat(new MSBibExportFormat());
        ExportFormats.putFormat(new MySQLExport());
        ExportFormats.putFormat(new PostgreSQLExport());
        JabRefPlugin plugin = JabRefPlugin.getInstance(PluginCore.getManager());
        if (plugin != null) {
            for (_JabRefPlugin.ExportFormatTemplateExtension exportFormatTemplateExtension : plugin.getExportFormatTemplateExtensions()) {
                PluginBasedExportFormat pluginBasedExportFormat = PluginBasedExportFormat.getFormat(exportFormatTemplateExtension);
                if (pluginBasedExportFormat == null) continue;
                ExportFormats.putFormat(pluginBasedExportFormat);
            }
            for (final _JabRefPlugin.ExportFormatExtension exportFormatExtension : plugin.getExportFormatExtensions()) {
                ExportFormats.putFormat(new IExportFormat(){
                    IExportFormat wrapped;

                    @Override
                    public String getConsoleName() {
                        return exportFormatExtension.getConsoleName();
                    }

                    @Override
                    public String getDisplayName() {
                        return exportFormatExtension.getDisplayName();
                    }

                    @Override
                    public FileFilter getFileFilter() {
                        return new ExportFileFilter(this, exportFormatExtension.getExtension());
                    }

                    @Override
                    public void performExport(BibtexDatabase database, MetaData metaData, String file, String encoding, Set<String> entryIds) throws Exception {
                        if (this.wrapped == null) {
                            this.wrapped = exportFormatExtension.getExportFormat();
                        }
                        this.wrapped.performExport(database, metaData, file, encoding, entryIds);
                    }
                });
            }
            for (_JabRefPlugin.ExportFormatProviderExtension exportFormatProviderExtension : plugin.getExportFormatProviderExtensions()) {
                IExportFormatProvider iExportFormatProvider = exportFormatProviderExtension.getFormatProvider();
                for (IExportFormat exportFormat : iExportFormatProvider.getExportFormats()) {
                    ExportFormats.putFormat(exportFormat);
                }
            }
        }
        TreeMap<String, ExportFormat> customFormats = Globals.prefs.customExports.getCustomExportFormats();
        for (IExportFormat iExportFormat : customFormats.values()) {
            ExportFormats.putFormat(iExportFormat);
        }
    }

    public static String getConsoleExportList(int maxLineLength, int firstLineSubtr, String linePrefix) {
        StringBuffer sb = new StringBuffer();
        int lastBreak = -firstLineSubtr;
        for (String name : exportFormats.keySet()) {
            if (sb.length() + 2 + name.length() - lastBreak > maxLineLength) {
                sb.append(",\n");
                lastBreak = sb.length();
                sb.append(linePrefix);
            } else if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    public static Map<String, IExportFormat> getExportFormats() {
        return Collections.unmodifiableMap(exportFormats);
    }

    public static IExportFormat getExportFormat(String consoleName) {
        return exportFormats.get(consoleName);
    }

    public static AbstractAction getExportAction(JabRefFrame frame, boolean selectedOnly) {
        class ExportAction
        extends MnemonicAwareAction {
            private static final long serialVersionUID = 639463604530580554L;
            private JabRefFrame frame;
            private boolean selectedOnly;

            public ExportAction(JabRefFrame frame, boolean selectedOnly) {
                this.frame = frame;
                this.selectedOnly = selectedOnly;
                this.putValue("Name", selectedOnly ? "Export selected entries" : "Export");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportFormats.initAllExports();
                JFileChooser fc = ExportFormats.createExportFileChooser(Globals.prefs.get("exportWorkingDirectory"));
                fc.showSaveDialog(this.frame);
                File file = fc.getSelectedFile();
                if (file == null) {
                    return;
                }
                FileFilter ff = fc.getFileFilter();
                if (ff instanceof ExportFileFilter) {
                    ExportFileFilter eff = (ExportFileFilter)ff;
                    String path = file.getPath();
                    if (!path.endsWith(eff.getExtension())) {
                        path = path + eff.getExtension();
                    }
                    if ((file = new File(path)).exists() && JOptionPane.showConfirmDialog(this.frame, "'" + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Export"), 2) != 0) {
                        return;
                    }
                    final IExportFormat format = eff.getExportFormat();
                    HashSet<String> entryIds = null;
                    if (this.selectedOnly) {
                        BibtexEntry[] selected = this.frame.basePanel().getSelectedEntries();
                        entryIds = new HashSet<String>();
                        for (int i = 0; i < selected.length; ++i) {
                            BibtexEntry bibtexEntry = selected[i];
                            entryIds.add(bibtexEntry.getId());
                        }
                    }
                    Globals.prefs.fileDirForDatabase = this.frame.basePanel().metaData().getFileDirectory("file");
                    Globals.prefs.databaseFile = this.frame.basePanel().metaData().getFile();
                    Globals.prefs.put("lastUsedExport", format.getConsoleName());
                    Globals.prefs.put("exportWorkingDirectory", file.getParent());
                    final File finFile = file;
                    final HashSet<String> finEntryIDs = entryIds;
                    AbstractWorker exportWorker = new AbstractWorker(){
                        String errorMessage = null;

                        @Override
                        public void run() {
                            try {
                                format.performExport(frame.basePanel().database(), frame.basePanel().metaData(), finFile.getPath(), frame.basePanel().getEncoding(), finEntryIDs);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                this.errorMessage = ex.getMessage() == null ? ex.toString() : ex.getMessage();
                            }
                        }

                        @Override
                        public void update() {
                            if (this.errorMessage == null) {
                                frame.output(Globals.lang("%0 export successful", format.getDisplayName()));
                            } else {
                                frame.output(Globals.lang("Could not save file") + " - " + this.errorMessage);
                                JOptionPane.showMessageDialog(frame, Globals.lang("Could not save file") + ".\n" + this.errorMessage, Globals.lang("Save database"), 0);
                            }
                        }
                    };
                    exportWorker.getWorker().run();
                    exportWorker.update();
                }
            }
        }
        return new ExportAction(frame, selectedOnly);
    }

    public static JFileChooser createExportFileChooser(String currentDir) {
        String lastUsedFormat = Globals.prefs.get("lastUsedExport");
        FileFilter defaultFilter = null;
        JFileChooser fc = new JFileChooser(currentDir);
        TreeSet<FileFilter> filters = new TreeSet<FileFilter>();
        for (Map.Entry<String, IExportFormat> e : exportFormats.entrySet()) {
            String formatName = e.getKey();
            IExportFormat format = e.getValue();
            filters.add(format.getFileFilter());
            if (!formatName.equals(lastUsedFormat)) continue;
            defaultFilter = format.getFileFilter();
        }
        for (FileFilter ff : filters) {
            fc.addChoosableFileFilter(ff);
        }
        fc.setAcceptAllFileFilterUsed(false);
        if (defaultFilter != null) {
            fc.setFileFilter(defaultFilter);
        }
        return fc;
    }

    private static void putFormat(IExportFormat format) {
        exportFormats.put(format.getConsoleName(), format);
    }
}

