/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.Globals;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableRemoveEntry;

public class StrictDuplicateSearch
extends Thread {
    BasePanel panel;

    public StrictDuplicateSearch(BasePanel bp) {
        this.panel = bp;
    }

    @Override
    public void run() {
        int i;
        HashSet<BibtexEntry> toRemove = new HashSet<BibtexEntry>();
        NamedCompound ce = new NamedCompound(Globals.lang("Remove duplicates"));
        this.panel.output(Globals.lang("Searching for duplicates..."));
        Object[] keys = this.panel.database.getKeySet().toArray();
        if (keys == null || keys.length < 2) {
            return;
        }
        BibtexEntry[] bes = new BibtexEntry[keys.length];
        for (i = 0; i < keys.length; ++i) {
            bes[i] = this.panel.database.getEntryById((String)keys[i]);
        }
        for (i = 0; i < bes.length - 1; ++i) {
            for (int j = i + 1; j < bes.length; ++j) {
                if (toRemove.contains(bes[i]) || toRemove.contains(bes[j]) || !(DuplicateCheck.compareEntriesStrictly(bes[i], bes[j]) > 1.0) || toRemove.contains(bes[i]) || toRemove.contains(bes[j])) continue;
                toRemove.add(bes[j]);
            }
        }
        if (toRemove.size() == 0) {
            this.panel.output(Globals.lang("No duplicates found") + ".");
            return;
        }
        int answer = JOptionPane.showConfirmDialog(this.panel.frame(), Globals.lang("Duplicates found") + ": " + toRemove.size() + ". " + Globals.lang("Remove all?"), Globals.lang("Remove duplicates"), 2);
        if (answer == 2) {
            return;
        }
        this.panel.output(Globals.lang("Duplicates removed") + ": " + toRemove.size());
        for (BibtexEntry entry : toRemove) {
            this.panel.database.removeEntry(entry.getId());
            ce.addEdit(new UndoableRemoveEntry(this.panel.database, entry, this.panel));
        }
        ce.end();
        this.panel.undoManager.addEdit(ce);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StrictDuplicateSearch.this.panel.markBaseChanged();
            }
        });
    }
}

